/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.application.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.controller.ApplicationUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.callback.util.CallBackLogStorage;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.util.DbTypeUtil;
import cn.myapps.util.json.JsonTmpUtil;
import cn.myapps.util.sequence.Sequence;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RequestMapping(value={"/api/designtime"})
@Scope(value="prototype")
public class ApplicationDesignTimeController
extends AbstractDesignTimeController {
    private ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();

    @GetMapping(value={"/applications"})
    @ApiOperation(value="\u83b7\u53d6\u8f6f\u4ef6\u5217\u8868", notes="\u83b7\u53d6\u8f6f\u4ef6\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u6216\u8005\u63cf\u8ff0\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchword", value="\u67e5\u8be2\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=false, paramType="query", dataType="Integer"), @ApiImplicitParam(name="pageNo", value="\u7b2c\u51e0\u9875", required=false, paramType="query", dataType="Integer"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="Integer")})
    public Resource getApplications(@RequestParam(required=false) String searchword, @RequestParam(required=false, defaultValue="0") Integer type, @RequestParam(required=false, defaultValue="1") Integer pageNo, @RequestParam(required=false, defaultValue="10") Integer linesPerPage) {
        try {
            List list = new ArrayList();
            String userId = Security.getDesignerIdFromToken((HttpServletRequest)this.request);
            SuperUserDesignTimeService process = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO superUserVO = process.doView(userId);
            if (superUserVO.isSuperAdmin()) {
                list = this.appService.list("", searchword);
            } else {
                Collection applications = superUserVO.getApplicationList();
                list = new ArrayList(applications);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Application application = (Application)iterator.next();
                if (2 != application.getType()) continue;
                iterator.remove();
            }
            DataPackage datas = new DataPackage();
            datas.setRowCount(list.size());
            datas.setLinesPerPage(linesPerPage.intValue());
            datas.setPageNo(pageNo.intValue());
            int beginIndex = (pageNo - 1) * linesPerPage;
            int endIndex = pageNo * linesPerPage;
            if (beginIndex >= list.size()) {
                datas.setDatas(null);
                datas.setRowCount(0);
            } else if (endIndex >= list.size()) {
                endIndex = list.size();
            }
            if (list.size() > 0) {
                datas.setDatas(list.subList(beginIndex, endIndex));
            }
            return this.success("ok", datas);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaasBadException(String.format("\u83b7\u53d6\u5e94\u7528\u5217\u8868\u53d1\u751f\u5f02\u5e38:%s", e.getMessage()), e);
        }
    }

    @GetMapping(value={"/applications/{applicationId}"})
    @ApiOperation(value="\u83b7\u53d6\u8f6f\u4ef6\u8be6\u60c5", notes="\u83b7\u53d6\u8f6f\u4ef6\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string")})
    public Resource getApplication(@PathVariable String applicationId) {
        try {
            Application application = (Application)this.appService.findById(applicationId);
            if (application == null) {
                throw new SaasNofoundException(String.format("\u627e\u4e0d\u5230\u5e94\u7528(%s)", applicationId));
            }
            JSONObject data = new JSONObject();
            data.put((Object)"id", (Object)application.getId());
            data.put((Object)"name", (Object)application.getName());
            data.put((Object)"description", (Object)application.getDescription());
            data.put((Object)"type", (Object)application.getType());
            data.put((Object)"activated", (Object)application.isActivated());
            data.put((Object)"orderNo", (Object)application.getOrderNo());
            data.put((Object)"uri", (Object)application.getUri());
            data.put((Object)"datasourceId", (Object)application.getDatasourceId());
            data.put((Object)"url", (Object)application.getUrl());
            data.put((Object)"token", (Object)application.getToken());
            data.put((Object)"encodingAESkey", (Object)application.getEncodingAESkey());
            if (application.getDataSourceDefine() == null) {
                data.put((Object)"datasourceName", (Object)"");
            } else {
                data.put((Object)"datasourceName", (Object)application.getDataSourceDefine().getName());
            }
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaasBadException(String.format("\u83b7\u53d6\u5e94\u7528\u660e\u7ec6\u53d1\u751f\u5f02\u5e38:%s", e.getMessage()), e);
        }
    }

    @PostMapping(value={"/applications"})
    @ApiOperation(value="\u65b0\u5efa\u8f6f\u4ef6", notes="\u65b0\u5efa\u8f6f\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8f6f\u4ef6\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createApplication(@RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Application application = (Application)this.json2obj(json, Application.class);
            String validateMessage = this.validate(application);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            application.setId(Sequence.getDesignTimeSequence());
            this.appService.save((Object)application);
            WebUser user = this.getUser();
            if (user.isDeveloper()) {
                this.setApplications(application, user);
            }
            JSONObject result = new JSONObject();
            result.put((Object)"id", (Object)application.getId());
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaasBadException(String.format("\u65b0\u589e\u5e94\u7528\u53d1\u751f\u5f02\u5e38:%s", e.getMessage()), e);
        }
    }

    @PutMapping(value={"/applications/{applicationId}"})
    @ApiOperation(value="\u66f4\u65b0\u8f6f\u4ef6", notes="\u66f4\u65b0\u8f6f\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8f6f\u4ef6\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateApplication(@PathVariable String applicationId, @RequestBody String content) {
        try {
            DataSourceDesignTimeService dataSourceService;
            DataSource dataSource;
            JSONObject json = JSONObject.fromObject((Object)content);
            String name = json.getString("name");
            String description = json.getString("description");
            int type = json.getInt("type");
            boolean activated = json.getBoolean("activated");
            int orderNo = json.getInt("orderNo");
            String datasourceId = json.getString("datasourceId");
            Application app = (Application)this.appService.findById(applicationId);
            Application application = (Application)BeanUtils.cloneBean((Object)app);
            application.setName(name);
            application.setDescription(description);
            application.setType(type);
            application.setActivated(activated);
            application.setOrderNo(Integer.valueOf(orderNo));
            application.setDatasourceId(datasourceId);
            String validateMessage = this.validate(application);
            if (!StringUtil.isBlank((String)validateMessage)) {
                return this.error(40001, validateMessage, null);
            }
            this.appService.update((Object)application);
            WebUser user = this.getUser();
            if (user.isDeveloper()) {
                this.setApplications(application, user);
            }
            if ((dataSource = (DataSource)(dataSourceService = DesignTimeServiceManager.dataSourceDesignTimeService()).findById(application.getDatasourceId())) != null) {
                DbTypeUtil._dbTypes.put(application.getId(), dataSource.getDbTypeName());
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaasBadException(String.format("\u66f4\u65b0\u5e94\u7528\u53d1\u751f\u5f02\u5e38:%s", e.getMessage()), e);
        }
    }

    @DeleteMapping(value={"/applications"})
    @ApiOperation(value="\u5220\u9664\u8f6f\u4ef6(\u53ef\u6279\u91cf)", notes="\u5220\u9664\u8f6f\u4ef6(\u53ef\u6279\u91cf)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource removeApplication(@RequestBody String content) {
        try {
            JSONArray appIds = JsonTmpUtil.fromObject((Object)content);
            for (String applicationId : appIds) {
                this.appService.delete(applicationId);
                SuperUserDesignTimeService sup = DesignTimeServiceManager.superUserDesignTimeService();
                Collection superUsers = sup.getAllSuperUser();
                for (SuperUserVO user : superUsers) {
                    Collection apps = user.getApplications();
                    Iterator it = apps.iterator();
                    while (it.hasNext()) {
                        String id = (String)it.next();
                        if (!applicationId.equals(id)) continue;
                        it.remove();
                        break;
                    }
                    user.setApplications(apps);
                    sup.doUpdate(user);
                }
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaasBadException(String.format("\u5220\u9664\u5e94\u7528\u53d1\u751f\u5f02\u5e38:%s", e.getMessage()), e);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/overview"})
    @ApiOperation(value="\u751f\u6210\u6982\u89c8", notes="\u751f\u6210\u6982\u89c8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string")})
    public ResponseEntity<byte[]> createOverview(@PathVariable String applicationId) {
        HttpHeaders headers = new HttpHeaders();
        try {
            String overViewFile = "appOverview" + System.currentTimeMillis() + ".pdf";
            ApplicationUtil.createOverview(applicationId, overViewFile);
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", overViewFile);
            return new ResponseEntity((Object)this.toByteArray(this.getOverview(overViewFile)), (MultiValueMap)headers, HttpStatus.CREATED);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.CREATED);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/getCallBackLogs"})
    @ApiOperation(value="\u83b7\u53d6\u5e73\u53f0\u6a21\u5f0f\u56de\u8c03\u65e5\u5fd7", notes="\u83b7\u53d6\u5e73\u53f0\u6a21\u5f0f\u56de\u8c03\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6Id", required=true, paramType="path", dataType="string")})
    public Resource getCallBackLogs(@PathVariable String applicationId) {
        try {
            Collection callBackLogs = CallBackLogStorage.getAll((String)applicationId);
            return this.success("ok", callBackLogs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void setApplications(Application application, WebUser user) throws Exception {
        SuperUserDesignTimeService process = DesignTimeServiceManager.superUserDesignTimeService();
        SuperUserVO spu = process.doView(user.getId());
        ArrayList<String> apps = spu.getApplications();
        if (apps == null) {
            apps = new ArrayList<String>();
            spu.setApplications(apps);
        }
        apps.add(application.getId());
        process.doUpdate(spu);
    }

    private InputStream getOverview(String overViewFile) throws Exception {
        String filePath = Environment.getInstance().getRealPath("/uploads") + "/overview/";
        FileInputStream is = new FileInputStream(filePath + overViewFile);
        if (filePath != null) {
            try {
                FileInputStream fileInputStream = is;
                new Thread(new Runnable(filePath, overViewFile){
                    final /* synthetic */ String val$filePath;
                    final /* synthetic */ String val$overViewFile;
                    {
                        this.val$filePath = string;
                        this.val$overViewFile = string2;
                    }

                    @Override
                    public void run() {
                        File file = new File(this.val$filePath + this.val$overViewFile);
                        while (file.exists() && !file.delete()) {
                        }
                    }
                }).start();
                return fileInputStream;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    new Thread(new /* invalid duplicate definition of identical inner class */).start();
                    throw throwable;
                }
            }
        }
        return null;
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private String validate(Application applicaiton) throws Exception {
        block5: {
            String name = applicaiton.getName();
            String id = applicaiton.getId();
            if (StringUtil.isBlank((String)name)) {
                return "\u8f6f\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
            }
            List list = this.appService.list(null, name);
            if (list == null || list.isEmpty()) break block5;
            if (id == null || "".equals(id)) {
                for (Application app : list) {
                    if (!app.getName().equals(name)) continue;
                    return "\u8be5\u8f6f\u4ef6\u540d\u79f0\u5df2\u5b58\u5728!";
                }
            } else {
                for (Application app : list) {
                    if (app.getId().equals(id) || !app.getName().equals(name)) continue;
                    return "\u8be5\u8f6f\u4ef6\u540d\u79f0\u5df2\u5b58\u5728!";
                }
            }
        }
        return null;
    }
}

