/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.api.group.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.api.group.ApiGroup;
import cn.myapps.designtime.api.group.service.ApiGroupDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"API\u5206\u7ec4\u64cd\u4f5c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ApiGroupDesignTimeController
extends AbstractDesignTimeController {
    private ApiGroupDesignTimeService apiGroupService = DesignTimeServiceManager.apiGroupDesignTimeService();

    @GetMapping(path={"/{applicationId}/apigroups"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6api\u5206\u7ec4\u5217\u8868", notes="\u83b7\u53d6api\u5206\u7ec4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=false, paramType="query", dataType="int")})
    public Resource getApiGroups(@PathVariable String applicationId, @RequestParam(required=false) String name, @RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="10") int linesPerPage) {
        try {
            DataPackage result = this.apiGroupService.query(applicationId, name, pageNo, linesPerPage);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/apigroups/{apiGroupId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6api\u5206\u7ec4\u8be6\u60c5", notes="\u83b7\u53d6api\u5206\u7ec4\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="apiGroupId", value="\u4e3b\u952e", required=true, paramType="path", dataType="string")})
    public Resource getApiGroup(@PathVariable String apiGroupId) {
        try {
            ApiGroup apiGroup = (ApiGroup)this.apiGroupService.findById(apiGroupId);
            return this.success("ok", apiGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/apigroups"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efaapi\u5206\u7ec4", notes="\u65b0\u5efaapi\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createApiGroup(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ApiGroup apiGroup = (ApiGroup)this.json2obj(json, ApiGroup.class);
            apiGroup.setApplicationid(applicationId);
            apiGroup.setParentId(applicationId);
            this.doSaveValidate(apiGroup);
            this.apiGroupService.saveOrUpdate((Object)apiGroup);
            JSONObject eipJson = new JSONObject();
            eipJson.put((Object)"id", (Object)apiGroup.getId());
            return this.success("ok", eipJson);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/apigroups/{apiGroupId}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u66f4\u65b0api\u5206\u7ec4", notes="\u66f4\u65b0api\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateApiGroup(@PathVariable String applicationId, @PathVariable String apiGroupId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ApiGroup ag = (ApiGroup)this.json2obj(json, ApiGroup.class);
            ApiGroup oldApiGroup = (ApiGroup)this.apiGroupService.findById(apiGroupId);
            ApiGroup apiGroup = (ApiGroup)BeanUtils.cloneBean((Object)oldApiGroup);
            apiGroup.setApplicationid(applicationId);
            apiGroup.setName(ag.getName());
            this.doSaveValidate(apiGroup);
            this.apiGroupService.saveOrUpdate((Object)apiGroup);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/apigroups"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664api", notes="\u5220\u9664api\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource deleteAipGroups(@RequestBody String content) {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.apiGroupService.delete(idArray);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(ApiGroup ac) throws Exception {
        List list = this.apiGroupService.list(ac.getParentId(), ac.getName());
        if (StringUtils.isBlank((String)ac.getId())) {
            for (ApiGroup apiGroup : list) {
                if (!apiGroup.getName().equals(ac.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            for (ApiGroup apiGroup : list) {
                if (apiGroup.getId().equals(ac.getId()) || !apiGroup.getName().equals(ac.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
    }
}

