/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.api.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.api.ApiConfig;
import cn.myapps.designtime.api.service.ApiDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"API\u4e2d\u5fc3\u64cd\u4f5c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ApiDesignTimeController
extends AbstractDesignTimeController {
    private ApiDesignTimeService apiService = DesignTimeServiceManager.apiDesignTimeService();

    @GetMapping(path={"/{applicationId}/apis"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6api\u5217\u8868", notes="\u83b7\u53d6api\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="requestType", value="\u8bf7\u6c42\u7c7b\u578b", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=false, paramType="query", dataType="int")})
    public Resource getApis(@PathVariable String applicationId, @RequestParam(required=false) String name, @RequestParam(required=false) String requestType, @RequestParam(required=false) String status, @RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="10") int linesPerPage) {
        try {
            DataPackage result = this.apiService.query(applicationId, name, requestType, "", status, pageNo, linesPerPage);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/apis/{apiId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6api\u8be6\u60c5", notes="\u83b7\u53d6api\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="apiId", value="\u4e3b\u952e", required=true, paramType="path", dataType="string")})
    public Resource getApi(@PathVariable String apiId) throws Exception {
        try {
            ApiConfig apiConfig = (ApiConfig)this.apiService.findById(apiId);
            return this.success("ok", apiConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/apis"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efaapi", notes="\u65b0\u5efaapi")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource createApi(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ApiConfig apiConfig = (ApiConfig)this.json2obj(json, ApiConfig.class);
            apiConfig.setApplicationid(applicationId);
            apiConfig.setParentId(applicationId);
            this.doSaveValidate(apiConfig);
            this.apiService.saveOrUpdate((Object)apiConfig);
            JSONObject eipJson = new JSONObject();
            eipJson.put((Object)"id", (Object)apiConfig.getId());
            return this.success("ok", eipJson);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/apis/{apiId}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u66f4\u65b0api", notes="\u66f4\u65b0api")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateApi(@PathVariable String applicationId, @PathVariable String apiId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            ApiConfig ac = (ApiConfig)this.json2obj(json, ApiConfig.class);
            ApiConfig oldApiConfig = (ApiConfig)this.apiService.findById(apiId);
            ApiConfig apiConfig = (ApiConfig)BeanUtils.cloneBean((Object)oldApiConfig);
            apiConfig.setApplicationid(applicationId);
            apiConfig.setName(ac.getName());
            apiConfig.setStatus(ac.getStatus());
            apiConfig.setTags(ac.getTags());
            apiConfig.setRequestType(ac.getRequestType());
            apiConfig.setRequestUrl(ac.getRequestUrl());
            apiConfig.setEncode(ac.getEncode());
            apiConfig.setResponseScript(ac.getResponseScript());
            apiConfig.setResponseType(ac.getResponseType());
            this.doSaveValidate(apiConfig);
            this.apiService.saveOrUpdate((Object)apiConfig);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/apis"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664api", notes="\u5220\u9664api\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteEips(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.apiService.delete(idArray);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(ApiConfig ac) throws Exception {
        List list = this.apiService.list(ac.getParentId(), ac.getName());
        if (StringUtils.isBlank((String)ac.getId())) {
            for (ApiConfig apiConfig : list) {
                if (!apiConfig.getName().equals(ac.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            for (ApiConfig apiConfig : list) {
                if (apiConfig.getId().equals(ac.getId()) || !apiConfig.getName().equals(ac.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
    }
}

