/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.activity.controller;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.activity.ActivityType;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.report.service.ReportDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.web.DWRHtmlUtils;
import cn.myapps.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ActivityUtil {
    public Map<String, String> getViewByModule(String moduleid, String application) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        if (moduleid.equals("")) {
            return map;
        }
        ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
        Collection col = vp.getViewsByModule(moduleid, application);
        for (AbstractView vw : col) {
            map.put(vw.getId(), vw.getName());
        }
        return map;
    }

    public Map<String, String> getFormByModule(String moduleid, String application) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        if (moduleid.equals("")) {
            return map;
        }
        FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
        Collection col = fp.getFormsByModule(moduleid, application);
        for (Form fm : col) {
            map.put(fm.getId(), fm.getName());
        }
        return map;
    }

    public Map<String, String> getNormalAndMappingFormByModule(String moduleid, String application) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        if (moduleid.equals("")) {
            return map;
        }
        FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
        Collection col = fp.getFormsByModule(moduleid, application);
        for (Form fm : col) {
            if (fm.getType() != 1 && fm.getType() != 65536) continue;
            map.put(fm.getId(), fm.getName());
        }
        return map;
    }

    public Map<String, String> getTemplateFormByModule(String moduleid, String application) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        if (moduleid.equals("")) {
            return map;
        }
        FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
        Collection col = fp.getTemplateFormsByModule(moduleid, application);
        for (Form fm : col) {
            if (fm.getType() != 0x100000) continue;
            map.put(fm.getId(), fm.getName());
        }
        return map;
    }

    public Map<String, String> getFlowByModule(String moduleid) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        if (moduleid.equals("")) {
            return map;
        }
        BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
        Collection col = bp.getBillDefiByModule(moduleid);
        for (BillDefiVO bv : col) {
            map.put(bv.getId(), bv.getSubject());
        }
        return map;
    }

    public String createViewType(String selectFieldName, String def) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("0", "{*[Select]*}");
        map.putAll(ActivityType.getViewActTypeMapWithMulti());
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String createFormType(String selectFieldName, String def) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("0", "{*[Select]*}");
        map.putAll(ActivityType.getFormActTypeMapWithMulti());
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String createFormTypeExceptJUMPAndDispatcher(String selectFieldName, String def) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("0", "{*[Select]*}");
        map.putAll(ActivityType.getFormActTypeMapWithMulti());
        map.remove(String.valueOf(32));
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String createType(String selectFieldName, String def) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("0", "{*[Select]*}");
        map.putAll(ActivityType.getFormActTypeMapWithMulti());
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String createOnActionView(String selectFieldName, String type, String moduleid, String def, String application) throws Exception {
        Map<Object, Object> map = new LinkedHashMap();
        if (!StringUtil.isBlank((String)type) && Integer.parseInt(type) == 1) {
            map = this.getViewByModule(moduleid, application);
        }
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String createOnActionForm(String selectFieldName, String type, String moduleid, String def, String application) throws Exception {
        Map<Object, Object> map = new LinkedHashMap();
        int typeCode = 0;
        try {
            typeCode = Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (typeCode == 2 || typeCode == 34 || typeCode == 18) {
            map = this.getNormalAndMappingFormByModule(moduleid, application);
        }
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String crateOnActionFlow(String selectFieldName, String type, String moduleid, String def) throws Exception {
        Map<Object, Object> map = new LinkedHashMap();
        if (!StringUtil.isBlank((String)type) && Integer.parseInt(type) == 5) {
            map = this.getFlowByModule(moduleid);
        }
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public String createOnActionRelatedForm(String selectFieldName, String type, String moduleid, String def, String application) throws Exception {
        Map<Object, Object> map = new LinkedHashMap();
        int typeCode = 0;
        try {
            typeCode = Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (typeCode == 13) {
            map = this.getTemplateFormByModule(moduleid, application);
        }
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public Map<String, String> getFlowsByModuleid(String moduleid) throws Exception {
        Map<String, String> map = new LinkedHashMap<String, String>();
        if (moduleid != null && !StringUtil.isBlank((String)moduleid)) {
            map = this.getFlowByModule(moduleid);
        }
        return map;
    }

    public String createOnActionPrint(String selectFieldName, String type, String moduleid, String def) throws Exception {
        Map<Object, Object> map = new LinkedHashMap();
        if (!(StringUtil.isBlank((String)type) || Integer.parseInt(type) != 30 && Integer.parseInt(type) != 31)) {
            map = this.getPrintByModule(moduleid);
        }
        return DWRHtmlUtils.createOptions(map, (String)selectFieldName, (String)def);
    }

    public Map<String, String> getPrintByModule(String moduleid) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("", "{*[Select]*}");
        if (moduleid.equals("")) {
            return map;
        }
        ReportDesignTimeService pp = DesignTimeServiceManager.reportDesignTimeService();
        Collection col = pp.getPrinterByModule(moduleid);
        for (Report printer : col) {
            if (printer.getIsPrint() != 1) continue;
            map.put(printer.getId(), printer.getName());
        }
        return map;
    }

    public List<?> parseXML(String activityXML) {
        return (List)XmlUtil.toOjbect((String)activityXML);
    }

    public String parseObject(List<Activity> activitySet) {
        return XmlUtil.toXml(activitySet);
    }

    public Activity save(Activity activity) throws Exception {
        try {
            Object viewService;
            AbstractView view;
            String viewId;
            FormDesignTimeService formService;
            Form form;
            List<Object> activities = new ArrayList();
            String formId = activity.getParentForm();
            if (!StringUtil.isBlank((String)formId) && !StringUtil.isBlank((String)(form = (Form)(formService = DesignTimeServiceManager.formDesignTimeService()).findById(formId)).getActivityXML())) {
                activities = this.parseXML(form.getActivityXML());
            }
            if (!StringUtil.isBlank((String)(viewId = activity.getParentView())) && !StringUtil.isBlank((String)(view = (AbstractView)(viewService = DesignTimeServiceManager.viewDesignTimeService()).findById(viewId)).getActivityXML())) {
                activities = this.parseXML(view.getActivityXML());
            }
            for (Activity act : activities) {
                if (act == null || !StringUtil.isBlank((String)activity.getId()) && act.getId().equals(activity.getId()) || !activity.getName().equals(act.getName())) continue;
                throw new Exception("\u8be5\u6309\u94ae\u540d\u79f0\u5df2\u5b58\u5728");
            }
            ActivityDesignTimeService service = DesignTimeServiceManager.activityDesignTimeService();
            if (!StringUtil.isBlank((String)activity.getParentForm())) {
                activity.setParentId(activity.getParentForm());
            } else {
                activity.setParentId(activity.getParentView());
            }
            service.saveOrUpdate((Object)activity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return activity;
    }

    public int remove(String id) {
        try {
            ActivityDesignTimeService service = DesignTimeServiceManager.activityDesignTimeService();
            service.delete(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public int swap(String id, String nId) {
        try {
            ActivityDesignTimeService service = DesignTimeServiceManager.activityDesignTimeService();
            Activity o = (Activity)service.findById(id);
            Activity n = (Activity)service.findById(nId);
            int tempOrder = o.getOrderno();
            o.setOrderno(n.getOrderno());
            n.setOrderno(tempOrder);
            service.update((Object)o);
            service.update((Object)n);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public String toListHtml(List<Activity> activitySet, HttpServletRequest request) {
        StringBuffer htmlBuilder = new StringBuffer();
        Map map = ActivityType.getViewActTypeMapWithMulti();
        Map formactMap = ActivityType.getFormActTypeMapWithMulti();
        int index = 0;
        htmlBuilder.append("<div id='contentTable' class='obpm-list-table'><table class='table_noborder tableTOver'>");
        htmlBuilder.append("<tr style='height:44px;' class='obpm-table-title'><td class='obpm-checkbox-col obpm-checkbox-section'><input id='table-content-title-act' type='checkbox' onclick='selectAllAct(this.checked)'><label class='obpm-checkbox' for='table-content-title-act'></label></td><td>{*[Activity]*}{*[Name]*}</td><td>{*[Activity]*}{*[Type]*}</td><td>{*[Move_Up]*}</td><td>{*[Move_Down]*}</td></tr>");
        String contextPath = request.getContextPath();
        for (Activity activity : activitySet) {
            if (index % 2 == 0) {
                htmlBuilder.append("<tr class='obpm-activity-table'>");
            } else {
                htmlBuilder.append("<tr class='obpm-activity-table'>");
            }
            htmlBuilder.append("<td class='obpm-checkbox-col obpm-checkbox-section'>");
            htmlBuilder.append("<input id='act_selects" + index + "' type=\"checkbox\" name=\"activitySelects\" value=" + index + ">");
            htmlBuilder.append("<label class='obpm-checkbox' for='act_selects" + index + "'></td>");
            htmlBuilder.append("<td>");
            htmlBuilder.append("<a href=\"javascript:actProcess.doEdit(" + index + ")\" style=\"cursor:hand\">" + activity.getName() + "</a>");
            htmlBuilder.append("</td>");
            htmlBuilder.append("<td>");
            String actType = (String)formactMap.get(activity.getType() + "");
            if (actType == null) {
                actType = (String)map.get(activity.getType() + "");
            }
            htmlBuilder.append("<a style=\"cursor:hand\">" + actType + "</a>");
            htmlBuilder.append("</td>");
            htmlBuilder.append("<td>");
            htmlBuilder.append("<a href=\"javascript:actProcess.doOrderChange(" + index + ", 'p')\"><img border=0 SRC=\"" + contextPath + "/resource/image/leftStep.GIF\"></a>");
            htmlBuilder.append("</td>");
            htmlBuilder.append("<td>");
            htmlBuilder.append("<a href=\"javascript:actProcess.doOrderChange(" + index + ", 'n')\"><img border=0 SRC=\"" + contextPath + "/resource/image/rightStep.GIF\"></a>");
            htmlBuilder.append("</td>");
            htmlBuilder.append("</tr>");
            ++index;
        }
        htmlBuilder.append("</table></div>");
        return htmlBuilder.toString();
    }

    public String getPrinterName(String printerId) throws Exception {
        Report printer;
        ReportDesignTimeService pp = DesignTimeServiceManager.reportDesignTimeService();
        if (!StringUtil.isBlank((String)printerId) && (printer = pp.doView(printerId)) != null) {
            return printer.getName();
        }
        return "";
    }
}

