/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.activity.controller;

import cn.myapps.common.model.activity.Activity;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.util.sequence.Sequence;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u64cd\u4f5c\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ActivityController
extends AbstractDesignTimeController {
    private ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();

    @GetMapping(path={"/modules/activitys/{activityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u64cd\u4f5c\u8be6\u60c5", notes="\u83b7\u53d6\u64cd\u4f5c\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="activityId", value="\u64cd\u4f5cid", required=true, paramType="path", dataType="string")})
    public Resource doGetActivityDetail(@PathVariable String activityId) throws Exception {
        try {
            Activity activity = (Activity)this.activityService.findById(activityId);
            return this.success("ok", activity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/activitys"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u64cd\u4f5c", notes="\u65b0\u5efa\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u64cd\u4f5c\u5bf9\u5e94id\uff08\u8868\u5355\u6216\u8005\u89c6\u56fe\uff09", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateActivity(@PathVariable String applicationId, @RequestParam String parentId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Activity activity = (Activity)this.json2obj(json, Activity.class);
            String activityId = Sequence.getDesignTimeSequence();
            activity.setId(activityId);
            activity.setParentId(parentId);
            activity.setApplicationid(applicationId);
            this.activityService.save((Object)activity);
            JSONObject activityJson = new JSONObject();
            activityJson.put((Object)"id", (Object)activityId);
            return this.success("ok", activityJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/modules/activitys/{activityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u64cd\u4f5c", notes="\u66f4\u65b0\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="activityId", value="\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u64cd\u4f5c\u5bf9\u5e94id\uff08\u8868\u5355\u6216\u8005\u89c6\u56fe\uff09", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateActivity(@PathVariable String applicationId, @PathVariable String activityId, @RequestParam String parentId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Activity activity = (Activity)this.json2obj(json, Activity.class);
            activity.setId(activityId);
            activity.setParentId(parentId);
            activity.setApplicationid(applicationId);
            this.activityService.update((Object)activity);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/activitys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u64cd\u4f5c", notes="\u5220\u9664\u64cd\u4f5c\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteForm(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.activityService.delete(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

