/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.conf;

import com.bcxin.saas.core.InjectResolver;
import com.bcxin.saas.core.InjectResolverFactory;
import com.bcxin.spring.adpater.config.InjectFactory;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class FeignConfig
implements RequestInterceptor,
ApplicationContextAware {
    public static String ADMIN_TOKEN;
    public static String ACCESS_TOKEN;
    public static String DESIGNER_TOKEN;

    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        requestTemplate.header("Cookie", new String[]{"adminToken=" + ADMIN_TOKEN + "; designerToken=" + DESIGNER_TOKEN + ""});
        requestTemplate.header("feignApi", new String[]{"true"});
    }

    public void setApplicationContext(final ApplicationContext appContext) throws BeansException {
        InjectFactory.setApplicationContext((ApplicationContext)appContext);
        InjectResolverFactory.setInjectResolver((InjectResolver)new InjectResolver(){

            public <T> T resolve(Class<T> tClass) {
                return (T)appContext.getBean(tClass);
            }

            public <T> T resolve(String beanName) {
                return (T)appContext.getBean(beanName);
            }
        });
    }
}

