/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.components;

import cn.myapps.components.ClearingEventHandler;
import cn.myapps.components.ProcessingEventHandler;
import cn.myapps.components.RingBufferProducer;
import cn.myapps.components.events.ObjectEvent;
import com.bcxin.saas.core.components.JsonProvider;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RingBufferConfig {
    @Bean
    public ProcessingEventHandler cacheEventHandler(DiscoveryClient discoveryClient, JsonProvider jsonProvider) {
        return new ProcessingEventHandler(discoveryClient, jsonProvider);
    }

    @Bean
    public RingBufferProducer ringBufferProducer(ProcessingEventHandler processingEventHandler) {
        int BUFFER_SIZE = 0x100000;
        Disruptor disruptor = new Disruptor(() -> new ObjectEvent(), 0x100000, (ThreadFactory)DaemonThreadFactory.INSTANCE);
        disruptor.handleEventsWith(new EventHandler[]{processingEventHandler}).then(new EventHandler[]{new ClearingEventHandler()});
        disruptor.start();
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        return new RingBufferProducer(ringBuffer);
    }
}

