package cn.myapps.designtime.permission.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import cn.myapps.common.Environment;
import cn.myapps.common.ModelSuffix;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.permission.Permission;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Api(tags = "角色授权设计模块")
@Component
@RequestMapping(path = "/api/designtime", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class PermissionDesigntimeConrtroller extends AbstractDesignTimeController {

    /**
     * 批量更新授权配置
     * @param applicationId
     *      软件id
     * @param content
     *      请求包体
     * @return
     */
    @PostMapping("/applications/{applicationId}/permissions")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "批量更新授权配置", notes = "批量更新授权配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content",value = "请求包体",required = false,paramType = "body",dataType = "string")
    })
    public Resource batchGrant(@PathVariable String applicationId, @RequestBody String content){
        try{
            JSONObject json = JSONObject.fromObject(content);
            List<String> roleIds = (List<String>) json.get("roles");
            List<JSONObject> resources = (List<JSONObject>) json.get("resources");
            List<JSONObject> views = (List<JSONObject>) json.get("views");
            List<JSONObject> forms = (List<JSONObject>) json.get("forms");

            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            //角色
            if(roleIds != null){
                for (String roleId: roleIds) {
                    Role role = roleDesignTimeService.findById(roleId);
                    //需要移除的资源id集合
                    List<String> removeResIdList = new ArrayList<String>();
                    //新增的资源对象集合
                    List<Permission> permissionList = new ArrayList<Permission>();

                    //菜单资源
                    if (resources != null) {
                        for (JSONObject resourceJson : resources) {
                            String resourceId = (String)resourceJson.get("id");
                            removeResIdList.add(resourceId);

                            boolean checked = resourceJson.getBoolean("checked");
                            if(checked){
                                Permission permission = PermissionUtil.createPermissionResource(roleId, resourceId);
                                permissionList.add(permission);
                            }
                        }
                    }
                    //视图资源
                    for (JSONObject viewJson: views) {
                        String viewId = (String) viewJson.get("id");
                        List<JSONObject> activities = (List<JSONObject>) viewJson.get("activities");
                        if(activities !=null){
                            removeResIdList.add(viewId);
                            for (JSONObject activityJson: activities) {
                                String activityId = (String)activityJson.get("id");
                                boolean checked = activityJson.getBoolean("checked");
                                if(checked){
                                    Permission permission = PermissionUtil.createPermission(viewId, activityId, Permission.VIEW_TYPE, roleId);
                                    permissionList.add(permission);
                                }
                            }
                        }
                    }
                    //表单资源
                    for (JSONObject formJson: forms) {
                        String formId = (String) formJson .get("id");
                        List<JSONObject> activities = (List<JSONObject>) formJson.get("activities");
                        if(activities !=null){
                            removeResIdList.add(formId);
                            for (JSONObject activityJson: activities) {
                                String activityId = (String)activityJson.get("id");
                                boolean checked = activityJson.getBoolean("checked");
                                if(checked) {
                                    Permission permission = PermissionUtil.createPermission(formId, activityId, Permission.FORM_TYPE, roleId);
                                    permissionList.add(permission);
                                }
                            }
                        }
                    }

                    if(role != null){
                        PermissionUtil.removeAuth(removeResIdList, role);
                        PermissionUtil.pushAuth(permissionList, role);
                        roleDesignTimeService.update(role);
                    }
                }
            }
            //清除redis中的缓存
            Environment.cleanPermissionMap();
            //初始化
            PermissionUtil.initPermissionMap();
            //角色-批量授权记录日志
            //LogHelper.saveLogByDyAdminAction("保存", "角色授权", applicationId, getUser(), request);
            return success("ok", "保存成功");
        } catch(Exception e){
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 查询pc菜单配置资源列表(根据上级)
     * @param applicationId
     *      软件id
     * @param roleId
     *      角色id
     * @param parentId
     *      上级菜单id
     * @return
     */
    @GetMapping("/applications/{applicationId}/permissions/pc")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "查询pc菜单配置资源列表", notes = "查询pc菜单配置资源列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "roleId", value = "角色id", required = false, paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "parentId", value = "上级菜单id", required = false, paramType = "query",dataType = "string")
    })
    public Resource getPcPermissionByRole(@PathVariable String applicationId, @RequestParam(required = false) String roleId, @RequestParam(required = false) String parentId){
        try{
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            Role role = roleDesignTimeService.findById(roleId);
//            Collection<ResourceVO> resources = rp.list(applicationId, null);
            Collection<ResourceVO> allResources = rp.deepQueryAll(applicationId, ModelSuffix.MENU_FILE_SUFFIX);

            Collection<ResourceVO> resources = new ArrayList<>();
            for (ResourceVO r : allResources) {
                if (r.getUri().endsWith(".menu")) {
                    resources.add(r);
                }
            }

            JSONArray result = new JSONArray();
            for (ResourceVO resourceVO: resources) {
                if(StringUtil.isBlank(parentId)){
                    parentId = applicationId;
                }
                if(!parentId.equals(resourceVO.getParentId())){
                    continue;
                }
                JSONObject json = new JSONObject();
                json.put("id", resourceVO.getId());
                json.put("parentId", resourceVO.getParentId());
                json.put("name", resourceVO.getName());
                String permissionType = resourceVO.getPermissionType();
                json.put("permissionType", permissionType);
                if(resourceVO.PERMISSION_TYPE_PUBLIC.equals(permissionType) || StringUtil.isBlank(roleId)){
                    json.put("checked", true);
                } else {
                    boolean checked = PermissionUtil.isExist(role, resourceVO.getId());
                    if(checked){
                        json.put("checked", true);
                    } else {
                        json.put("checked", false);
                    }
                }
                Collection<ResourceVO> subResources = rp.list(resourceVO.getId(), null);
                if(subResources != null && !subResources.isEmpty()){
                    json.put("hasChild", true);
                } else {
                    json.put("hasChild", false);
                }
                result.add(json);
            }
            return success("ok", result);
        } catch (Exception e){
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 查询mobile菜单配置资源列表(根据上级)
     * @param applicationId
     *      软件id
     * @param roleId
     *      角色id
     * @param parentId
     *      上级菜单id
     * @return
     */
    @GetMapping("/applications/{applicationId}/permissions/mobile")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "查询mobile菜单配置资源列表", notes = "查询mobile菜单配置资源列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "roleId", value = "角色id", required = false, paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "parentId", value = "上级菜单id", required = false, paramType = "query",dataType = "string")
    })
    public Resource getMobilePermissionByRole(@PathVariable String applicationId, @RequestParam(required = false) @PathVariable String roleId, @RequestParam(required = false) String parentId){
        try{
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            Role role = roleDesignTimeService.findById(roleId);
//            Collection<ResourceVO> resources = rp.list(applicationId, ModelSuffix.MOBILE_MENU_PATH_SUFFIX, ModelSuffix.MOBILE_MENU_FILE_SUFFIX, null);
            Collection<ResourceVO> resources = rp.deepQueryAll(applicationId, ModelSuffix.MOBILE_MENU_FILE_SUFFIX);
            JSONArray result = new JSONArray();
            for (ResourceVO resourceVO: resources) {
                if(StringUtil.isBlank(parentId)){
                    parentId = applicationId;
                }
                if(!parentId.equals(resourceVO.getParentId())){
                    continue;
                }
                JSONObject json = new JSONObject();
                json.put("id", resourceVO.getId());
                json.put("parentId", resourceVO.getParentId());
                json.put("name", resourceVO.getName());
                String permissionType = resourceVO.getPermissionType();
                json.put("permissionType", permissionType);
                if(ResourceVO.PERMISSION_TYPE_PUBLIC.equals(permissionType) || StringUtil.isBlank(roleId)){
                    json.put("checked", true);
                } else {
                    boolean checked = PermissionUtil.isExist(role, resourceVO.getId());
                    if(checked){
                        json.put("checked", true);
                    } else {
                        json.put("checked", false);
                    }
                }
                Collection<ResourceVO> subResources = rp.list(resourceVO.getId(), ModelSuffix.MOBILE_MENU_PATH_SUFFIX, ModelSuffix.MOBILE_MENU_FILE_SUFFIX, null);
                if(subResources != null && !subResources.isEmpty()){
                    json.put("hasChild", true);
                } else {
                    json.put("hasChild", false);
                }
                result.add(json);
            }
            return success("ok", result);
        } catch (Exception e){
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 查询模块配置资源列表(根据上级)
     * @param applicationId
     *      软件id
     * @param parentId
     *      上级模块id
     * @return
     */
    @GetMapping("/applications/{applicationId}/permissions/module")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "查询模块配置资源列表", notes = "查询模块配置资源列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "parentId", value = "上级菜单id", required = true, paramType = "query",dataType = "string")
    })
    public Resource getModulePermissionByRole(@PathVariable String applicationId, @RequestParam(required = false) String parentId){
        try{
            ModuleDesignTimeService moduleService = DesignTimeServiceManager.moduleDesignTimeService();
            Collection<Module> modules = moduleService.list(applicationId,null);
            JSONArray result = new JSONArray();
            for (Module module: modules) {
                if(StringUtil.isBlank(parentId)){
                    parentId = applicationId;
                }
                if(!parentId.equals(module.getParentId())){
                    continue;
                }
                JSONObject json = new JSONObject();
                json.put("id", module.getId());
                json.put("parentId", module.getParentId());
                json.put("name", module.getName());
                Collection<Module> subModules = moduleService.list(module.getId(),null);
                if(subModules != null && !subModules.isEmpty()){
                    json.put("hasChild", true);
                } else {
                    json.put("hasChild", false);
                }
                result.add(json);
            }
            return success("ok", result);
        } catch (Exception e){
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 查询所属模块的表单或视图配置资源列表
     * @param applicationId
     *      软件id
     * @param roleId
     *      角色id
     * @param moduleId
     *      模块id
     * @return
     */
    @GetMapping("/applications/{applicationId}/modules/{moduleId}/permissions")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "查询所属模块的表单或视图配置资源列表", notes = "查询所属模块的表单或视图配置资源列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "roleId", value = "角色id", required = false, paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path",dataType = "string")
    })
    public Resource getModulePermissionByRole(@PathVariable String applicationId, @RequestParam(required = false) @PathVariable String roleId, @PathVariable String moduleId){
        try{
            JSONObject result = new JSONObject();
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            Role role = roleDesignTimeService.findById(roleId);
            //表单资源
            FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
            Collection<Form> forms = fp.getFormsByModule(moduleId, applicationId);
            JSONArray formArr = new JSONArray();
            for (Form form: forms) {
                JSONObject formJson = new JSONObject();
                formJson.put("id", form.getId());
                String name = "";
                //描述不为空的话。返回描述作为名称
                if(!StringUtil.isBlank(form.getDescription())){
                    name = form.getDescription();
                }else {
                    name = form.getName();
                }
                formJson.put("name", name);
                String permissionType = form.getPermissionType();
                formJson.put("permissionType", permissionType);
                //表单按钮资源
                List<Activity> orginActivities = form.getActivities();
                List<Activity> activities = new ArrayList<Activity>();
                activities.addAll(orginActivities);
                //添加打开的按钮
                Activity open = new Activity();
                open.setId(form.getId());
                open.setName("打开");
                activities.add(open);
                JSONArray activityArr = new JSONArray();
                for (Activity activity: activities) {
                    JSONObject activityJson = new JSONObject();
                    activityJson.put("id", activity.getId());
                    activityJson.put("name", activity.getName());
                    if(ResourceVO.PERMISSION_TYPE_PUBLIC.equals(permissionType) || StringUtil.isBlank(roleId)){
                        activityJson.put("checked", true);
                    } else {
                        boolean checked = PermissionUtil.isExist(role, activity.getId());
                        if(checked){
                            activityJson.put("checked", true);
                        } else {
                            activityJson.put("checked", false);
                        }
                    }
                    activityArr.add(activityJson);
                }
                formJson.put("activities", activityArr);
                formArr.add(formJson);
            }
            result.put("forms", formArr);
            //视图资源
            ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
            Collection<AbstractView> views = vp.getViewsByModule(moduleId, applicationId);
            JSONArray viewArr = new JSONArray();
            for (AbstractView view: views) {
                JSONObject viewJson = new JSONObject();
                viewJson.put("id", view.getId());
                String name = "";
                //描述不为空的话。返回描述作为名称
                if(!StringUtil.isBlank(view.getDescription())){
                    name = view.getDescription();
                }else {
                    name = view.getName();
                }
                viewJson.put("name", name);
                String permissionType = view.getPermissionType();
                viewJson.put("permissionType", permissionType);
                //视图按钮资源
                List<Activity> orginActivities = view.getActivities();
                List<Activity> activities = new ArrayList<Activity>();
                activities.addAll(orginActivities);
                //添加打开的按钮
                Activity open = new Activity();
                open.setId(view.getId());
                open.setName("打开");
                activities.add(open);
                JSONArray activityArr = new JSONArray();
                for (Activity activity: activities) {
                    JSONObject activityJson = new JSONObject();
                    activityJson.put("id", activity.getId());
                    activityJson.put("name", activity.getName());
                    if(ResourceVO.PERMISSION_TYPE_PUBLIC.equals(permissionType) || StringUtil.isBlank(roleId)){
                        activityJson.put("checked", true);
                    } else {
                        boolean checked = PermissionUtil.isExist(role, activity.getId());
                        if(checked){
                            activityJson.put("checked", true);
                        } else {
                            activityJson.put("checked", false);
                        }
                    }
                    activityArr.add(activityJson);
                }
                viewJson.put("activities", activityArr);
                viewArr.add(viewJson);
            }
            result.put("views", viewArr);

            return success("ok", result);
        } catch (Exception e){
            return error(500, e.getMessage(), null);
        }
    }
}
