package cn.myapps.designtime.form.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.table.Confirm;
import cn.myapps.common.model.table.NeedConfirmException;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.controller.ActivityUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.helper.service.HelpHelper;
import cn.myapps.designtime.helper.toc.ITopic;
import cn.myapps.designtime.helper.toc.TocFileParser;
import cn.myapps.designtime.helper.toc.impl.Toc;
import cn.myapps.runtime.dynaform.document.dql.DQLASTUtil;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.form.ejb.*;
import cn.myapps.runtime.dynaform.form.ejb.mapping.ColumnMapping;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;
import cn.myapps.runtime.dynaform.form.helper.FormHelper;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.util.http.CookieUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

import java.util.*;

import static com.jayway.jsonpath.JsonPath.parse;

@Api(tags = "表单设计模块")
@Component
@RequestMapping(path = "/api/designtime/applications", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FormController extends AbstractDesignTimeController {

    private FormDesignTimeService formService;

    private ActivityDesignTimeService activityService;

    public FormController() throws Exception {
        formService = (FormDesignTimeService) DesignTimeServiceManager.formDesignTimeService();
        activityService = DesignTimeServiceManager.activityDesignTimeService();
    }

    /**
     * 获取表单列表
     *
     * @param moduleId 模块id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/{moduleId}/forms")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取表单列表", notes = "获取表单列表（可根据名字或者描述查询）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "name", value = "名称", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "description", value = "描述", required = false, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "type", value = "表单类型", required = false, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "pageNo", value = "当前页数", required = true, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "linesPerPage", value = "每页行数", required = true, paramType = "query", dataType = "String"),
    })
    public Resource doGetFormList(@PathVariable String moduleId, @RequestParam(required = false) String name,String description ,@RequestParam(required = false) String type,
                                  String pageNo,String linesPerPage) throws Exception {
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        int line = (linesPerPage != null && linesPerPage.length() > 0) ? Integer.parseInt(linesPerPage) : 10;
        int formType = (type != null && type.length() > 0) ?  Integer.parseInt(type) : 0;
        try {

            DataPackage<Form> forms = new DataPackage<>();
            forms = formService.queryByNameOrDescript(moduleId, name, page, line);


            Collection<Form> formsList = forms.getDatas();
            JSONArray formArray = new JSONArray();
            // 1- 普通表单 2 - 标签页 256 - 查询表单 65536 - 普通(映射) 1048576 - 模板表单
            if (formType != 0) {
                for (Form form : formsList) {

                    if (form.getType() == formType) {
                        String formId = form.getId();
                        String formName = form.getName();
                        String formDiscription = form.getDescription();
                        int formOrderno = form.getOrderno();
                        JSONObject formJson = new JSONObject();
                        formJson.put("id", formId);
                        formJson.put("name", formName);
                        formJson.put("description", formDiscription);
                        formJson.put("orderno", formOrderno);
                        formArray.add(formJson);
                    }
                }
                return success("ok", formArray);
            } else {
                return success("ok", forms);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取表单详情
     *
     * @param formId 表单id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/{formId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取表单详情", notes = "获取表单详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string")
    })
    public Resource doGetFormDetailed(@PathVariable String formId) throws Exception {
        try {
            Form form = formService.findById(formId);

            return success("ok", form);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 新建表单
     *
     * @param applicationId 软件id
     * @param moduleId 模块id
     * @param content  请求包体
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/{applicationId}/modules/{moduleId}/forms")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "新建表单", notes = "新建表单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doCreateForm(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content) throws Exception {
        try {

            JSONObject json = JSONObject.fromObject(content);
            Form form = (Form)json2obj(json,Form.class);
            form.setApplicationid(applicationId);
            form.setParentId(moduleId);

            String formId = Sequence.getDesignTimeSequence();
            form.setId(formId);

            doSaveValidate(form);
            formService.doCreate(form);

            JSONObject formJson = new JSONObject();
            formJson.put("id", formId);

            return success("ok", formJson);
        } catch (OBPMValidateException ex){
            ex.printStackTrace();
            return error(40001, ex.getValidateMessage(), null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新表单
     *
     * @param applicationId 软件id
     * @param moduleId 模块id
     * @param formId  表单id
     * @param content 请求包体
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/{applicationId}/modules/{moduleId}/forms/{formId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新表单", notes = "更新表单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "moduleId", value = "模块id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdateForm(@PathVariable String applicationId, @PathVariable String moduleId, @PathVariable String formId, @RequestBody String content) throws Exception {

        try {
            JSONObject json = JSONObject.fromObject(content);
            Form form = (Form)json2obj(json,Form.class);
            form.setApplicationid(applicationId);
            form.setParentId(moduleId);
            form.setId(formId);
            //重名校验
            doSaveValidate(form);
            formService.doUpdate(form);

            return success("ok", null);
        } catch (OBPMValidateException ex){
            ex.printStackTrace();
            if(ex.getCause() != null && ex.getCause() instanceof NeedConfirmException){
                Collection<Confirm> confirms = null;

                NeedConfirmException cause = (NeedConfirmException) ex.getCause();
                confirms = cause.getConfirms();
                Iterator<Confirm> iterator = confirms.iterator();
                if (iterator.hasNext()){
                    Confirm confirm = (Confirm) iterator.next();
                    return error(40001, confirm.getMessage(), null);
                } else {
                    return error(40001, ex.getValidateMessage(), null);
                }
            }else{
                return error(40001, ex.getValidateMessage(), null);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除表单（可批量）
     *
     * @param content 请求包体
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/modules/forms")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除表单", notes = "删除表单（可批量）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doDeleteForm(@RequestBody String content) throws Exception {
        try {
            List<String> ids = parse(content).json();
            String[] idArray = {};
            idArray = ids.toArray(idArray);

            formService.delete(idArray);

            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取表单字段列表
     *
     * @param formId 表单id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/{formId}/fields")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取表单字段列表", notes = "获取表单字段列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "type", value = "获取字段的类型", required = false, paramType = "query", dataType = "string")
    })
    public Resource doGetFormField(@PathVariable String formId, @RequestParam(required = false) String type) throws Exception {

        try {
            JSONArray fieldArray = new JSONArray();
            Form form = formService.findById(formId);
            if (form != null) {
                form.inited();
                Collection<FormField> colls = form.getAllFields();
                IRunner runner = JavaScriptFactory.getInstance("", form.getApplicationid());
                runner.initBSFManager(new Document(), new ParamsTable(), getUser(), new ArrayList<ValidateMessage>());
                for (Iterator<FormField> iter = colls.iterator(); iter.hasNext(); ) {
                    FormField field = iter.next();
                    if (type == null && (field instanceof IncludeField
                            || (field instanceof HTMLEditorField)
                            || (field instanceof TabField)
                            || (field instanceof CalctextField)
                            || (field instanceof FlowHistoryField)
                            || (field instanceof FileManagerField)
                            || (field instanceof ImageUploadToDataBaseField)
                            || (field instanceof ViewDialogField)
                            || (field instanceof ReminderField)
                            || (field instanceof FlowReminderHistoryField))) {
                        continue;
                    } else if(type != null && "eventMapping".equals(type) && !(field instanceof InputField || field instanceof SuggestField)){
                        continue;
                    } else if(type != null && "dataMapping".equals(type) && !(field instanceof TextareaField)){
                        continue;
                    }
                    JSONObject fieldJson = new JSONObject();
                    fieldJson.put("id", field.getId());
                    fieldJson.put("name", field.getName());
                    String discript = field.getDiscript(runner);
                    fieldJson.put("discript", discript);
                    fieldJson.put("type", field.getFieldtype());
                    fieldArray.add(fieldJson);
                }
            }
            return success("ok", fieldArray);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取表单清除数据字段列表
     *
     * @param formId 表单id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/{formId}/clearFields")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取表单清除数据字段列表", notes = "获取表单清除数据字段列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string")
    })
    public Resource doGetFormClearField(@PathVariable String formId) throws Exception {

        try {
            JSONArray fieldArray = new JSONArray();

            Form form = formService.findById(formId);
            if (form != null) {
                form.inited();
                Collection<FormField> colls = form.getValueStoreFields();
                for (Iterator<FormField> iter = colls.iterator(); iter.hasNext(); ) {
                    FormField field = iter.next();

                    JSONObject fieldJson = new JSONObject();
                    fieldJson.put("id", field.getId());
                    fieldJson.put("name", field.getName());
                    fieldJson.put("type", field.getFieldtype());
                    fieldArray.add(fieldJson);

                }
            }
            return success("ok", fieldArray);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取表单操作列表
     *
     * @param formId 表单id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/{formId}/activitys")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取表单操作列表", notes = "获取表单操作列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string")
    })
    public Resource doGetFormActivityList(@PathVariable String formId) throws Exception {

        try {
            Form form = formService.findById(formId);
            form.setActivities(null);
            List<Activity> list = form.getActivities();
            return success("ok", list);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取表单操作详情
     *
     * @param activityId 表单操作id
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/activitys/{activityId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取表单操作详情", notes = "获取表单操作详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "表单操作id", required = true, paramType = "path", dataType = "string")
    })
    public Resource doGetFormActivity(@PathVariable String activityId) throws Exception {
        try {
            Activity activity = activityService.findById(activityId);
            return success("ok", activity);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 新建表单操作
     *
     * @param applicationId 软件id
     * @param formId 表单id
     * @param content  请求包体
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/{applicationId}/modules/forms/{formId}/activitys")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "新建表单操作", notes = "新建表单操作")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doCreateFormActivity(@PathVariable String applicationId, @PathVariable String formId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject(content);
            Activity activity = (Activity)json2obj(json,Activity.class);

            List<Activity> activities = new ArrayList<>();
            ActivityUtil activityUtil = new ActivityUtil();
            Form form = formService.findById(formId);
            //获取该视图下的按钮
            if(!StringUtil.isBlank(form.getActivityXML())){
                activities = (List<Activity>) activityUtil.parseXML(form.getActivityXML());
            }
            //校验名称是否已存在
            for(Activity act: activities) {
                if(act != null &&  (StringUtil.isBlank(activity.getId()) || !act.getId().equals(activity.getId()))  && activity.getName().equals(act.getName())) {
                    throw new Exception("该按钮名称已存在");
                }
            }
            if(activity != null) {
                activity.setApplicationid(applicationId);
                activity.setParentForm(formId);
                activity.setParentId(formId);

                String activityId = Sequence.getDesignTimeSequence();
                if(StringUtil.isBlank(activity.getId())){
                    activity.setId(activityId);
                }
                activityService.saveOrUpdate(activity);

                JSONObject columnJson = new JSONObject();
                columnJson.put("id", activityId);

                return success("ok", columnJson);
            }
            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新表单操作
     *
     * @param applicationId  软件id
     * @param formId 表单id
     * @param activityId  表单列id
     * @param content 请求包体
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/{applicationId}/modules/forms/{formId}/activitys/{activityId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新表单操作", notes = "更新表单操作")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "activityId", value = "表单操作id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdateFormActivity(@PathVariable String applicationId, @PathVariable String formId, @PathVariable String activityId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject(content);
            Activity activity = (Activity)json2obj(json,Activity.class);

            if(activity != null) {
                activity.setApplicationid(applicationId);
                activity.setParentId(formId);
                activity.setParentForm(formId);
                activity.setId(activityId);

                activityService.update(activity);
            }
            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除表单操作（可批量）
     *
     * @param ids 请求包体
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/modules/forms/activitys")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除表单操作", notes = "删除表单操作（可批量）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doDeleteFormActivity(@RequestBody String[] ids) {
        try {
            activityService.delete(ids);
            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 重置字段编号(返回随机数)
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/getSequence")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "重置字段编号(返回随机数)", notes = "重置字段编号(返回随机数)")
    public Resource getSequence(){
        try{
            return success("ok", Sequence.getDesignTimeSequence());
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 清除表单字段数据
     * @param formId
     * @param fields
     * @return
     */
    @PostMapping(path = "/modules/forms/cleardata")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "清除表单字段数据", notes = "清除表单字段数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "fields", value = "请求包体", required = true, paramType = "body", dataType = "string"),
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "query", dataType = "string")
    })
    public Resource cleardata(@RequestParam String formId,@RequestBody String[] fields){
        try{
            Form form = formService.findById(formId);
            formService.doClearColumnData(form, fields);
            return success("ok", null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }

    /**
     * 表单帮助接口
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/help")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "表单帮助接口", notes = "表单帮助接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帮助id", required = true, paramType = "query", dataType = "string")
    })
    public Resource getFormHelp(@RequestParam String id) throws Exception {

        String language = CookieUtil.getMultiLanguage(request);
        JSONObject data = new JSONObject();
        TocFileParser tocp = TocFileParser.getInstance();
        Toc toc = tocp.getToc(language);
        if (validateString(id)) {
            ITopic topic = toc.getTopicById(id);

            if (topic !=null && validateString(topic.getId())) {
                //html = "{href:\""+topic.getHref()+"\",label:\"{*["+topic.getLabel()+"]*}\"}";
                data.put("href",topic.getHref());
                data.put("label","{*["+topic.getLabel()+"]*}");
            }
        }

        return success("ok",data);
    }

    /**
     * 帮助接口树形结构
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/getHelpTreeIndex")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "帮助接口树形结构", notes = "帮助接口树形结构")
    public Resource getHelpTreeIndex() throws Exception {
        HelpHelper helpHelper = new HelpHelper();
        String html = helpHelper.doHelpTreeIndex("",request);
        return success("ok",html);
    }

    /**
     * 获取数据表名称映射
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/dataBaseTableMap")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取数据表名称映射", notes = "获取数据表名称映射")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "query", dataType = "string")
    })
    public Resource getDataBaseTableMap(@RequestParam String applicationId){
        try{
            FormHelper formHelper = new FormHelper();
            Map<String, String> dataBaseTableMap = formHelper.getDataBaseTableMap(applicationId);
            return success("ok",dataBaseTableMap);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }

    /**
     * 获取数据库列名称映射
     * @return
     * @throws Exception
     */
    @GetMapping(path = "/modules/forms/dataBaseColumnMap")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取数据库列名称映射", notes = "获取数据库列名称映射")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "tableName", value = "表名", required = true, paramType = "query", dataType = "string")
    })
    public Resource getDataBaseColumnMap(@RequestParam String tableName,@RequestParam String applicationId) throws Exception {
        try{
            FormHelper formHelper = new FormHelper();
            Map<String, String> dataBaseColumnMap = formHelper.getDataBaseColumnMap(tableName,applicationId);
            return success("ok",dataBaseColumnMap);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 映射表单同步数据
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/modules/forms/synchronouslyData")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "映射表单同步数据", notes = "映射表单同步数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "formId", value = "表单id", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "domainId", value = "企业域id", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "tableName", value = "表名", required = true, paramType = "query", dataType = "string")
    })
    public Resource synchronouslyData(@RequestParam String formId,@RequestParam String domainId,@RequestParam String tableName) throws Exception {
        try{
            Form form = formService.doView(formId);
            if(form == null ){
                return error(500, "该表单不存在，请保存后操作！", null);
            }
            if (StringUtil.isBlank(form.getTableMapping().getPrimaryKeyName())) {
                return error(500, "{*[noPrimaryKeyName]*}", null);
            }
            ParamsTable params = this.getParams();
            params.setParameter("domainName",domainId);
            params.setParameter("application",form.getApplicationid());
            String reuslt = formService.doSynchronouslyData(params, this.getUser(), form);
            String msg = "";
            if (reuslt == "success") {
                msg = "{*[synchronouslyDataSuccess]*}";
            } else if (reuslt == "exist") {
                msg = "{*[hasSynchronouslyData]*}";
            } else if (reuslt == "noexist") {
                msg = "{*[Database]*}{*[Table]*}" +tableName+ "{*[Data]*} IS NULL";
            }
            return success("ok",msg);
        }catch (Exception e){
            return error(500, e.getMessage(), null);
        }
    }

    public Boolean validateString(String str) {
        Boolean rtn = false;
        if (str != null && !str.equals("") && !str.equals("undefined")) {
            rtn = true;
        }
        return rtn;

    }
    /**
     * 保存前的一系列校验
     *
     * @param form
     * @throws Exception
     */
    private void doSaveValidate(Form form) throws Exception {
        String name = "";
        ParamsTable params = this.getParams();
        if (form != null) {

            name = form.getName();
            params.setParameter("s_name", name);

            // 名称重复检验

            Form form_Exsited = formService.doViewByFormName(name,
                    form.getApplicationid());
            if (form_Exsited != null && StringUtil.isBlank(form.getId())) {// 判断新建不能重名
                throw new OBPMValidateException("[" + name + "]{*[core.form.exist]*}");
            } else if (form_Exsited != null
                    && !form_Exsited.getId().trim().equalsIgnoreCase(
                    form.getId())) {// 修改不能重名
                throw new OBPMValidateException("[" + name + "]{*[core.form.exist]*}");
            }
        }

        //名称长度校验
//        if(!StringUtil.isBlank(name) && name.length()>40){
//            throw new OBPMValidateException("名称的长度不能超过40个字符");
//        }

        Collection<FormField> formFields = form.getValueStoreFields();
        //查询表单
        if(form.getType() == Form.FORM_TYPE_SEARCHFORM){
            Collection<FormField> fields = form.getFields();
            for(Iterator<FormField> iterator = fields.iterator(); iterator.hasNext();){
                FormField formField = iterator.next();
                if(formField instanceof SelectAboutField){
                    throw new OBPMValidateException("查询表单不能包含左右选择框");
                }
            }
        }

        // 表单映射检验
        String tableName = form.getTableMapping().getTableName();
        int type = form.getType();
        if (StringUtil.isBlank(tableName)
                && type == Form.FORM_TYPE_NORMAL_MAPPING) {
            throw new OBPMValidateException(" {*[core.form.type.tableName.select]*} ");
        } else if (!StringUtil.isBlank(tableName)
                && type == Form.FORM_TYPE_NORMAL_MAPPING) {
            // 映射字段校验
            TableMapping tableMapping = form.getTableMapping();
            if (null != tableMapping.getPrimaryKeyMapping()) {

                Collection<ColumnMapping> columnMappings = tableMapping
                        .getColumnMappings();
                if (null != columnMappings && columnMappings.size() > 0) {
                    for (Iterator<ColumnMapping> cmsit = columnMappings
                            .iterator(); cmsit.hasNext();) {

                        ColumnMapping cm = (ColumnMapping) cmsit.next();

                        if (!cm.getColumnName().equals("")
                                ^ !cm.getFieldName().equals("")) {
                            throw new OBPMValidateException(
                                    "{*[core.mapping.field.select]*}");
                        }

                        if (!cm.getFieldName().equals("MAPPINGID")) {
                            for (Iterator<?> it = DQLASTUtil.SYSTEM_FIELDS
                                    .iterator(); it.hasNext();) {
                                String systemField = (String) it.next();
                                if (systemField.equalsIgnoreCase(cm
                                        .getColumnName())) {
                                    throw new OBPMValidateException(
                                            "{*[core.mapping.field.was.duplicate.with.sys]*}: "
                                                    + cm.getColumnName());
                                }
                            }
                        }
                    }
                }
            } else {
                throw new OBPMValidateException("{*[core.mapping.primarykey.select]*}");
            }
        }

        // 变更校验
        //doChangeValidate(form, params);
        formService.doChangeValidate(form);
    }

}

