package cn.myapps.designtime.fckeditor.connector;

import cn.myapps.common.util.PropertyUtil;
import net.fckeditor.handlers.PropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletContext;

public class ContextConnector extends AbstractLocalFileSystemConnector {
    private final Logger logger;

    public ContextConnector() {
        this.logger = LoggerFactory.getLogger(ContextConnector.class);
    }

    public void init(ServletContext servletContext) throws Exception {
        this.servletContext = servletContext;
        String defaultAbsolutePath = this.getRealUserFilesAbsolutePath(PropertiesLoader.getUserFilesPath());
        if (defaultAbsolutePath == null) {
            /*
            this.logger.error("The context root cannot be resolved against the local filesystem");
            this.logger.info("Your servlet container/application server does not expand deployed war files");
            this.logger.debug("Use another Connector implementation (e.g. LocalConnector) and consult http://www.fckeditor.net/forums/viewtopic.php?f=6&t=11568");

             */
            throw new NullPointerException("The real context root cannot be resolved against the local filesystem");
        }
    }

    protected String getRealUserFilesAbsolutePath(String userFilesAbsolutePath) {
        return PropertyUtil.getPath()+"/uploads"+userFilesAbsolutePath;
    }
}
