package cn.myapps.components;

import cn.myapps.components.events.ObjectEvent;
import com.bcxin.saas.core.components.JsonProvider;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.util.DaemonThreadFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RingBufferConfig  {

    @Bean
    public ProcessingEventHandler cacheEventHandler(DiscoveryClient discoveryClient, JsonProvider jsonProvider) {
        return new ProcessingEventHandler(discoveryClient, jsonProvider);
    }

    @Bean
    public RingBufferProducer ringBufferProducer(ProcessingEventHandler processingEventHandler) {
        final int BUFFER_SIZE = 1024 * 1024;
        Disruptor<ObjectEvent<?>> disruptor = new Disruptor<>(
                () -> new ObjectEvent<>(), BUFFER_SIZE, DaemonThreadFactory.INSTANCE);
        disruptor
                .handleEventsWith(processingEventHandler)
                .then(new ClearingEventHandler());

        disruptor.start();

        RingBuffer<ObjectEvent<?>> ringBuffer = disruptor.getRingBuffer();
        return new RingBufferProducer(ringBuffer);
    }
}
