package cn.myapps.components;

import cn.myapps.components.events.DistributeDesignCacheObject;
import cn.myapps.components.events.ObjectEvent;
import cn.myapps.designtime.requests.RefreshDesignRequest;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.CompleteFurtherUtils;
import com.lmax.disruptor.EventHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

import java.util.List;

public class ProcessingEventHandler implements EventHandler<ObjectEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessingEventHandler.class);
    private final DiscoveryClient discoveryClient;
    private final JsonProvider jsonProvider;

    public ProcessingEventHandler(DiscoveryClient discoveryClient, JsonProvider jsonProvider) {
        this.discoveryClient = discoveryClient;
        this.jsonProvider = jsonProvider;
    }

    @Override
    public void onEvent(ObjectEvent event, long l, boolean b) throws Exception {
        List<ServiceInstance> runtimeInstances =
                this.discoveryClient.getInstances("obpm-runtime");
        DistributeDesignCacheObject cacheEvent = (DistributeDesignCacheObject) event.getData();
        try {
            if (!CollectionUtils.isEmpty(runtimeInstances)) {
                String finalAppId = cacheEvent.getAppId();
                CompleteFurtherUtils.execute(runtimeInstances, (instance) -> {
                    doRefreshRequest(instance, finalAppId, cacheEvent.getData());
                });
            }
        } finally {
            logger.error("推送数据到obpm-runtime实例:{}-数据={}", runtimeInstances.size(), cacheEvent);
        }
    }

    private void doRefreshRequest(ServiceInstance instance, String appId, RefreshDesignRequest rq) {
        String targetUrl = String.format("%s/obpm/api/runtime/applications/%s/components/do-refresh",
                instance.getUri(),
                appId);

        try {
            CloseableHttpClient httpClient = null;
            try {
                httpClient = HttpClientBuilder.create().build();

                HttpPut put = new HttpPut(targetUrl);

                String json = this.jsonProvider.getJson(rq);
                put.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
                CloseableHttpResponse response = httpClient.execute(put);
                String result = EntityUtils.toString(response.getEntity(), "UTF-8");

                logger.error("推送表单数据至{}-数据={} 保存结果为:{}-{}",
                        put.getURI(), json, response.getStatusLine(), result);
            } finally {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
        } catch (Exception ex) {
            logger.error("刷新runtime({})组件缓存发生异常:{}", targetUrl, rq, ex);
        }
    }
}
