/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.common.filter;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.http.CookieUtil;
import cn.myapps.util.property.MultiLanguageProperty;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

class MultiLanguagePrintWriter
extends PrintWriter {
    int flag;
    int count;
    int[] buf = new int[512];
    String domain;
    String application;
    String language;
    int size;
    HttpServletRequest request;

    public MultiLanguagePrintWriter(ServletRequest inRequ, ServletResponse inResp) throws IOException {
        this(inResp.getWriter(), false);
        this.out = inResp.getWriter();
        inResp.setCharacterEncoding("UTF-8");
        HttpServletRequest request = (HttpServletRequest)inRequ;
        WebUser webUser = null;
        if (request.getRequestURI().indexOf("dwr") < 0) {
            webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
        }
        this.language = CookieUtil.getMultiLanguage((HttpServletRequest)request);
        if (StringUtil.isBlank((String)this.language)) {
            Locale loc = request.getLocale();
            if (loc.equals(Locale.CHINA) || loc.equals(Locale.PRC)) {
                this.language = "CN";
            } else if (loc.equals(Locale.TAIWAN)) {
                this.language = "TW";
            } else {
                this.language = loc.getLanguage().toUpperCase();
                if (MultiLanguageProperty.getType((String)this.language) == 0) {
                    this.language = "EN";
                }
            }
        }
        if (webUser != null) {
            this.application = webUser.getDefaultApplication();
            this.domain = webUser.getDomainid();
        } else {
            this.application = null;
            this.domain = null;
        }
    }

    public MultiLanguagePrintWriter(Writer out, boolean autoFlush) {
        super(out);
    }

    @Override
    public void flush() {
        if (this.count > 0) {
            this.clearBuf();
        }
        super.flush();
    }

    @Override
    public void close() {
        if (this.count > 0) {
            this.clearBuf();
        }
        super.close();
    }

    @Override
    public void write(char[] buf2, int off, int len) {
        for (int i = off; i < Math.min(off + len, buf2.length); ++i) {
            this.write(buf2[i]);
        }
    }

    @Override
    public void write(String s) {
        this.write(s.toCharArray(), 0, s.length());
    }

    private void writeToBuf(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            int[] newbuf = new int[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = b;
        this.count = newcount;
    }

    @Override
    public void write(int c) {
        switch (c) {
            case 123: {
                if (this.flag == 0) {
                    this.flag = 1;
                    this.writeToBuf(c);
                    break;
                }
                this.clearBuf();
                super.write(c);
                ++this.size;
                break;
            }
            case 42: {
                if (this.flag == 1) {
                    this.flag = 2;
                    this.writeToBuf(c);
                    break;
                }
                if (this.flag == 4) {
                    this.flag = 5;
                    this.writeToBuf(c);
                    break;
                }
                this.clearBuf();
                super.write(c);
                ++this.size;
                break;
            }
            case 91: {
                if (this.flag == 2) {
                    this.flag = 3;
                    this.writeToBuf(c);
                    break;
                }
                this.clearBuf();
                super.write(c);
                ++this.size;
                break;
            }
            case 93: {
                if (this.flag == 3) {
                    this.flag = 4;
                    this.writeToBuf(c);
                    break;
                }
                this.clearBuf();
                super.write(c);
                ++this.size;
                break;
            }
            case 125: {
                if (this.flag == 5) {
                    this.writeToBuf(c);
                    String origText = StringUtil.toString((int[])this.buf, (int)3, (int)(this.count - 6));
                    String newText = MultiLanguageProperty.replaceText((String)this.application, (String)this.language, (String)origText);
                    try {
                        super.write(newText);
                        this.size += newText.getBytes("UTF-8").length;
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.count = 0;
                    this.flag = 0;
                    break;
                }
                this.clearBuf();
                super.write(c);
                ++this.size;
                break;
            }
            default: {
                if (this.flag == 3) {
                    this.writeToBuf(c);
                    break;
                }
                if (this.count > 0) {
                    this.clearBuf();
                }
                super.write(c);
                ++this.size;
            }
        }
    }

    private void clearBuf() {
        for (int i = 0; i < this.count; ++i) {
            super.write(this.buf[i]);
            ++this.size;
        }
        this.count = 0;
        this.flag = 0;
    }

    public int getSize() {
        return this.size;
    }
}

