/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.listener;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.Environment;
import cn.myapps.common.util.cache.EhcacheProvider;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.designtime.common.cache.DesignTimeIndexCacheManager;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;

public class ApplicationContextEventListener
implements ApplicationListener<ApplicationContextEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            logger.info("\u521d\u59cb\u5316Designer\u5f00\u59cb");
            long start = System.currentTimeMillis();
            try {
                Environment evt = Environment.getInstance();
                String workRootPath = evt.getWorkspaceRootPath();
                File newPath = new File(workRootPath);
                if (!newPath.exists()) {
                    logger.error(workRootPath + "\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
                }
                DesignTimeIndexCacheManager.getInstance().init(2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    DesignTimeSerializableCache.flush2SecondCached();
                    PersistenceUtils.closeSessionAndConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            logger.info("\u521d\u59cb\u5316Designer\u7ed3\u675f\uff0c\u7528\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms.");
        } else if (event instanceof ContextClosedEvent || event instanceof ContextStoppedEvent) {
            logger.info("\u5f00\u59cb\u5378\u8f7d\u8d44\u6e90");
            try {
                EhcacheProvider cacheProvider = (EhcacheProvider)MyCacheManager.getProviderInstance();
                cacheProvider.destory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

