/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.wizard.service;

import cn.myapps.authtime.common.dao.IAuthTimeDAO;
import cn.myapps.authtime.common.service.AbstractAuthTimeServiceImpl;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.view.dto.ViewDirector;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.column.service.ColumnDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.designtime.wizard.service.WizardProcess;
import cn.myapps.designtime.wizard.service.WizardVO;
import cn.myapps.designtime.wizard.util.WizardUtil;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.dao.DAOFactory;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.sequence.Sequence;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WizardProcessBean
extends AbstractAuthTimeServiceImpl<WizardVO>
implements WizardProcess {
    private static final long serialVersionUID = -1074889227713498941L;
    private ModuleDesignTimeService moduleProcess;
    private FormDesignTimeService formService;
    private static final WizardUtil wizardUtil = new WizardUtil();
    private ViewDesignTimeService viewService;
    private BillDefiDesignTimeService billDefiService;
    private ResourceDesignTimeService resourceService;
    private ApplicationDesignTimeService applicationProcess;

    protected IAuthTimeDAO<WizardVO> getDAO() throws Exception {
        return DAOFactory.getDefaultDAO((String)WizardVO.class.getName());
    }

    public WizardProcessBean() {
        try {
            this.setupProcesses();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupProcesses() throws Exception {
        this.moduleProcess = DesignTimeServiceManager.moduleDesignTimeService();
        this.formService = DesignTimeServiceManager.formDesignTimeService();
        this.viewService = DesignTimeServiceManager.viewDesignTimeService();
        this.billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
        this.resourceService = DesignTimeServiceManager.resourceDesignTimeService();
        this.applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
    }

    @Override
    public void confirm(ValueObject vo, IUser user, String applicationid, String contextBasePath) throws Exception {
        WizardVO wizardvo = (WizardVO)vo;
        Module module = null;
        try {
            module = this.createModule(wizardvo, applicationid);
            Form mainForm = this.createMainForm(wizardvo, module, contextBasePath);
            Form subForm = null;
            if (wizardvo.getF_Type().equals("01")) {
                subForm = this.createSubForm(wizardvo, module, contextBasePath);
                AbstractView subView = this.createViewForSubForm(wizardvo, module, subForm, contextBasePath);
                wizardvo.setF_subForm_viewid(subView.getId());
            }
            this.createWorkflow(wizardvo, module, mainForm, user, contextBasePath);
            ResourceVO topMenu = this.createResource(wizardvo, module);
            this.createView(wizardvo, module, topMenu, mainForm, contextBasePath);
        }
        catch (Exception e) {
            if (module != null) {
                this.moduleProcess.delete(module.getId());
            }
            e.printStackTrace();
        }
    }

    private void updateSubForm(Form mainForm, AbstractView subView, WizardVO wizardvo, String contextBasePath) throws Exception {
        mainForm.setTemplatecontext(mainForm.getTemplatecontext() + wizardUtil.getUpdatedTemplateContext(wizardvo, contextBasePath));
        this.formService.doUpdate(mainForm);
    }

    private BillDefiVO createWorkflow(WizardVO vo, Module Module2, Form form, IUser user, String contextBasePath) throws Exception {
        BillDefiVO billDefiVO = new BillDefiVO();
        Date lastmodify = new Date();
        if (vo.getW_workflowid() == null || vo.getW_workflowid().trim().length() == 0) {
            billDefiVO.setApplicationid(vo.getApplicationid());
            billDefiVO.setAuthorname(user.getName());
            billDefiVO.setAuthorno(user.getLoginno());
            billDefiVO.setParentId(Module2.getId());
            billDefiVO.setId(Sequence.getDesignTimeSequence());
            billDefiVO.setFlow(wizardUtil.getW_content(contextBasePath, vo.getW_content()));
            billDefiVO.setLastmodify(lastmodify);
            billDefiVO.setSubject(vo.getW_name());
            this.billDefiService.doCreate(billDefiVO);
        } else {
            billDefiVO = this.billDefiService.doView(vo.getW_workflowid());
            if (billDefiVO != null) {
                billDefiVO.setSubject(vo.getW_name());
                billDefiVO.setFlow(vo.getW_content());
                this.billDefiService.doUpdate(billDefiVO);
            }
        }
        ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
        Activity activity = new Activity();
        activity.setId(Sequence.getDesignTimeSequence());
        activity.setName("Submit_WorkFlow");
        activity.setApplicationid(vo.getApplicationid());
        if (billDefiVO != null) {
            activity.setOnActionFlow(billDefiVO.getId());
        }
        activity.setParentForm(form.getId());
        activity.setType(5);
        activity.setParent((FileSystemDesignTimeSerializable)form);
        activity.setParentId(form.getId());
        activityService.save((Object)activity);
        return billDefiVO;
    }

    private AbstractView createViewForSubForm(ValueObject vo, Module module, Form form, String contextBasePath) throws Exception {
        String[] v_activity;
        WizardVO wizardVO = (WizardVO)vo;
        Module Module2 = form.getModule();
        AbstractView view = ViewDirector.construct((int)1);
        String formName = Module2.getParent().getName() + "/" + Module2.getName() + "/" + form.getName();
        String filterCode = "\"$formname = '" + formName + "\"";
        view.setId(Sequence.getDesignTimeSequence());
        view.setApplicationid(vo.getApplicationid());
        view.setName("SubFormView_".concat(wizardVO.getF_name_sub()));
        view.setOpenType(16);
        view.setEditMode("00");
        view.setFilterScript(filterCode);
        view.setModule(Module2);
        view.setShowTotalRow(false);
        view.setPagination(true);
        view.setPageLines("15");
        view.setRelatedForm(form.getId());
        view.setParentId(module.getId());
        this.viewService.doCreate(view);
        ArrayList<Column> subFormViewColumn = new ArrayList<Column>();
        ColumnDesignTimeService columnService = DesignTimeServiceManager.columnDesignTimeService();
        String[] fields = null;
        if (wizardVO.getF_subForm_viewColumns().trim().length() > 0 && !wizardVO.getF_subForm_viewColumns().equals("")) {
            fields = wizardVO.getF_subForm_viewColumns().split(";");
        }
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                Column column = new Column();
                column.setId(Sequence.getDesignTimeSequence());
                column.setOrderno(i);
                column.setFormid(form.getId());
                column.setApplicationid(vo.getApplicationid());
                column.setParentView(view.getId());
                column.setFieldName(fields[i]);
                column.setName(fields[i]);
                column.setParent((FileSystemDesignTimeSerializable)view);
                column.setParentId(view.getId());
                columnService.save((Object)column);
                subFormViewColumn.add(column);
            }
        }
        ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
        Activity activity = null;
        if (wizardVO.getF_subForm_viewActivitys() != null && (v_activity = wizardVO.getF_subForm_viewActivitys()) != null && v_activity.length > 0) {
            for (int i = 0; i < v_activity.length; ++i) {
                activity = new Activity();
                activity.setId(Sequence.getDesignTimeSequence());
                activity.setName(WizardVO._VIEWACLIST.get(v_activity[i]));
                activity.setType(Integer.parseInt(v_activity[i]));
                activity.setParentView(view.getId());
                activity.setOrderno(i + 1);
                activity.setApplicationid(vo.getApplicationid());
                activity.setParent((FileSystemDesignTimeSerializable)view);
                activity.setParentId(view.getId());
                activityService.save((Object)activity);
            }
        }
        return view;
    }

    private void createView(WizardVO vo, Module Module2, ResourceVO resource, Form form, String contextBasePath) throws Exception {
        String[] v_type;
        String pendingFilterScript = "";
        String allFilterScript = "";
        String formName = Module2.getParent().getName() + "/" + Module2.getName() + "/" + form.getName();
        Form searchForm = new Form();
        if (vo.getV_searchForm().length() > 0 && vo.getV_searchForm() != null) {
            searchForm.setApplicationid(vo.getApplicationid());
            searchForm.setId(Sequence.getDesignTimeSequence());
            searchForm.setModule(Module2);
            searchForm.setSortId(Sequence.getTimeSequence());
            searchForm.setName(vo.getF_name() + "_Search");
            searchForm.setType(256);
            searchForm.setTemplatecontext(wizardUtil.getV_searchForm(vo.getV_searchForm(), contextBasePath));
            searchForm.setParent((FileSystemDesignTimeSerializable)Module2);
            searchForm.setParentId(Module2.getId());
            this.formService.doCreate(searchForm);
            searchForm = this.formService.doView(searchForm.getId());
        }
        if ((v_type = vo.getV_type()) != null && v_type.length > 0) {
            for (int i = 0; i < v_type.length; ++i) {
                if (v_type[i].equalsIgnoreCase("Pending")) {
                    vo.setPending(true);
                    if (vo.getV_filter() != null && vo.getV_filter().length() > 0) {
                        pendingFilterScript = wizardUtil.getV_filter(contextBasePath, vo, formName);
                    }
                    String v_description = vo.getV_description();
                    vo.setV_description("");
                    this.getview(vo, Module2, resource, form, searchForm, pendingFilterScript, v_type[i]);
                    vo.setV_description(v_description);
                    continue;
                }
                allFilterScript = formName;
                if (vo.getV_filter() != null && vo.getV_filter().length() > 0) {
                    allFilterScript = wizardUtil.getV_filter(contextBasePath, vo, formName);
                }
                this.getview(vo, Module2, resource, form, searchForm, allFilterScript, v_type[i]);
            }
        }
    }

    private void getview(WizardVO vo, Module Module2, ResourceVO resource, Form form, Form searchForm, String filterscript, String v_type) throws Exception {
        String[] v_activity;
        AbstractView view = ViewDirector.construct((int)1);
        view.setId(Sequence.getDesignTimeSequence());
        view.setApplicationid(vo.getApplicationid());
        view.setDescription(vo.getV_description());
        if (v_type != null && v_type.equalsIgnoreCase("Pending")) {
            view.setName(vo.getV_name() + "_" + "Pending");
        } else {
            view.setName(vo.getV_name());
        }
        view.setOpenType(1);
        view.setEditMode("01");
        view.setFilterScript(filterscript);
        view.setParent((FileSystemDesignTimeSerializable)Module2);
        view.setParentId(Module2.getId());
        view.setShowTotalRow(vo.getV_isShowTotalRow() == null ? false : vo.getV_isShowTotalRow().equalsIgnoreCase("true"));
        view.setPagination(vo.getV_isPagination() == null ? false : vo.getV_isPagination().equalsIgnoreCase("true"));
        view.setPageLines(vo.getV_pagelines());
        if (searchForm != null) {
            Form _searchForm = new Form();
            _searchForm.setId(searchForm.getId());
            view.setSearchForm(_searchForm);
        }
        ResourceVO resourceVO = new ResourceVO();
        resourceVO.setActionContent(view.getId());
        resourceVO.setApplicationid(view.getApplicationid());
        resourceVO.setLinkName(view.getName());
        resourceVO.setLinkType(ResourceVO.LinkType.VIEW.getCode());
        resourceVO.setQueryString("[]");
        resourceVO.setModuleid(view.getParent().getId());
        resourceVO.setId(Sequence.getDesignTimeSequence());
        resourceVO.setSuperior(resource.getId());
        resourceVO.setApplicationid(vo.getApplicationid());
        resourceVO.setParentId(vo.getApplicationid());
        if (v_type == null || !v_type.equalsIgnoreCase("Pending")) {
            resourceVO.setDescription(vo.getV_description() + "_" + "All");
        }
        if ("Pending".equalsIgnoreCase(v_type)) {
            resourceVO.setDescription(vo.getV_name() + "_" + "Pending");
        }
        resourceVO.setType("00");
        view.setRelatedResourceId(resourceVO.getId());
        this.viewService.doCreate(view);
        this.resourceService.saveOrUpdate((Object)resourceVO);
        this.getAllColumn(vo, view, form, vo.getApplicationid());
        ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
        Activity act = null;
        if (v_type != null && v_type.equalsIgnoreCase("All") && (v_activity = vo.getV_activity()) != null && v_activity.length > 0) {
            for (int i = 0; i < v_activity.length; ++i) {
                act = new Activity();
                act.setId(Sequence.getDesignTimeSequence());
                act.setName(WizardVO._VIEWACLIST.get(v_activity[i]));
                act.setType(Integer.parseInt(v_activity[i]));
                if (v_activity[i].equals("1") || v_activity[i].equals("16")) {
                    act.setOnActionView(view.getId());
                } else if (v_activity[i].equals("2") || v_activity[i].equals("4")) {
                    act.setOnActionForm(form.getId());
                }
                act.setParentView(view.getId());
                act.setOrderno(i + 1);
                act.setApplicationid(vo.getApplicationid());
                act.setParent((FileSystemDesignTimeSerializable)view);
                act.setParentId(view.getId());
                activityService.save((Object)act);
            }
        }
    }

    private ResourceVO createResource(WizardVO vo, Module Module2) throws Exception {
        ResourceVO resource = new ResourceVO();
        resource.setId(Sequence.getDesignTimeSequence());
        resource.setApplicationid(vo.getApplicationid());
        resource.setDescription(vo.getR_description());
        resource.setOrderno(Integer.valueOf(vo.getR_orderno()));
        resource.setType("00");
        resource.setParentId(vo.getApplicationid());
        if (!vo.getR_superior().equals("")) {
            resource.setSuperior(vo.getR_superior());
        }
        this.resourceService.doCreate(resource);
        return resource;
    }

    private Form createMainForm(WizardVO wizardvo, Module Module2, String contextBasePath) throws Exception {
        ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
        Form form = null;
        if (wizardvo.getF_formid() == null || wizardvo.getF_formid().trim().length() == 0) {
            form = new Form();
            form.setApplicationid(wizardvo.getApplicationid());
            form.setModule(Module2);
            form.setDescription(wizardvo.getF_description());
            form.setName(wizardvo.getF_name());
            form.setTemplatecontext(wizardUtil.getF_TemplateContext(wizardvo.getF_templatecontext(), wizardvo.getF_style(), contextBasePath));
            form.setSortId(Sequence.getTimeSequence());
            form.setType(1);
            form.setParent((FileSystemDesignTimeSerializable)Module2);
            form.setParentId(Module2.getId());
            this.formService.doCreate(form);
            String[] f_activitys = wizardvo.getF_activitys();
            if (f_activitys != null && f_activitys.length > 0) {
                for (int i = 0; i < f_activitys.length && !f_activitys[i].equals(String.valueOf(5)); ++i) {
                    Activity act = new Activity();
                    act.setId(Sequence.getDesignTimeSequence());
                    act.setName(WizardVO._FORMACLIST.get(f_activitys[i]));
                    act.setType(Integer.parseInt(f_activitys[i]));
                    act.setOnActionForm(form.getId());
                    act.setApplicationid(wizardvo.getApplicationid());
                    act.setOrderno(i + 1);
                    act.setParentForm(form.getId());
                    act.setParent((FileSystemDesignTimeSerializable)form);
                    act.setParentId(form.getId());
                    activityService.save((Object)act);
                }
            }
        }
        return form;
    }

    private Form createSubForm(WizardVO wizardvo, Module Module2, String contextBasePath) throws Exception {
        ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();
        Form form = null;
        if (wizardvo.getF_formId_sub() == null || wizardvo.getF_formId_sub().trim().length() == 0) {
            form = new Form();
            form.setApplicationid(wizardvo.getApplicationid());
            form.setModule(Module2);
            form.setDescription(wizardvo.getF_description_sub());
            form.setName(wizardvo.getF_name_sub());
            form.setTemplatecontext(wizardUtil.getF_TemplateContext(wizardvo.getF_fieldsdescription_sub(), wizardvo.getF_style_sub(), contextBasePath));
            form.setSortId(Sequence.getTimeSequence());
            form.setType(1);
            form.setParent((FileSystemDesignTimeSerializable)Module2);
            form.setParentId(Module2.getId());
            this.formService.doCreate(form);
            String[] f_activitys = wizardvo.getF_activitys_sub();
            if (f_activitys != null && f_activitys.length > 0) {
                for (int i = 0; i < f_activitys.length && !f_activitys[i].equals(String.valueOf(5)); ++i) {
                    Activity act = new Activity();
                    act.setId(Sequence.getDesignTimeSequence());
                    act.setName(WizardVO._FORMACLIST.get(f_activitys[i]));
                    act.setType(Integer.parseInt(f_activitys[i]));
                    act.setOnActionForm(form.getId());
                    act.setParentForm(form.getId());
                    act.setOrderno(i + 1);
                    act.setApplicationid(wizardvo.getApplicationid());
                    act.setParent((FileSystemDesignTimeSerializable)form);
                    act.setParentId(form.getId());
                    activityService.save((Object)act);
                }
            }
        }
        return form;
    }

    private Module createModule(WizardVO vo, String applicationid) throws Exception {
        Module Module2 = new Module();
        Application appvo = (Application)this.applicationProcess.findById(applicationid);
        if (vo.getModuleid() == null || vo.getModuleid().trim().length() == 0) {
            Module2.setId(Sequence.getDesignTimeSequence());
            Module2.setApplicationid(appvo.getId());
            Module2.setParentId(appvo.getId());
            Module2.setName(vo.getM_name());
            Module2.setDescription(vo.getM_description());
            this.moduleProcess.save((Object)Module2);
        } else {
            Module2 = (Module)this.moduleProcess.findById(vo.getModuleid());
            if (Module2 != null) {
                Module2.setName(vo.getM_name());
                Module2.setDescription(vo.getM_description());
                this.moduleProcess.update((Object)Module2);
            }
        }
        if (Module2 != null) {
            vo.setModuleid(Module2.getId());
        }
        return Module2;
    }

    private List<Column> getAllColumn(WizardVO wizardvo, AbstractView view, Form form, String applicationid) throws Exception {
        ColumnDesignTimeService service = DesignTimeServiceManager.columnDesignTimeService();
        ArrayList<Column> v_cloumns = new ArrayList<Column>();
        String[] fields = null;
        if (wizardvo.getV_columns().trim().length() > 0 && !wizardvo.getV_columns().equals("")) {
            fields = wizardvo.getV_columns().split(";");
        }
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                Column columns = new Column();
                columns.setOrderno(i);
                columns.setFormid(form.getId());
                columns.setApplicationid(applicationid);
                columns.setParentView(view.getId());
                columns.setFieldName(fields[i]);
                columns.setName(fields[i]);
                columns.setId(Sequence.getDesignTimeSequence());
                columns.setParent((FileSystemDesignTimeSerializable)view);
                columns.setParentId(view.getId());
                service.save((Object)columns);
                v_cloumns.add(columns);
            }
        }
        return v_cloumns;
    }
}

