/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.view.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.link.LinkVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.CalendarView;
import cn.myapps.common.model.view.CollapsibleView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.model.view.GanttView;
import cn.myapps.common.model.view.ListView;
import cn.myapps.common.model.view.MapView;
import cn.myapps.common.model.view.TreeView;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.controller.ActivityUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.link.service.LinkDesignTimeService;
import cn.myapps.designtime.view.column.service.ColumnDesignTimeService;
import cn.myapps.designtime.view.controller.ViewHelper;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.form.helper.FormHelper;
import cn.myapps.util.json.JsonTmpUtil;
import cn.myapps.util.sequence.Sequence;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u89c6\u56fe\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ViewController
extends AbstractDesignTimeController {
    private ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
    private FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
    private ColumnDesignTimeService columnsService = DesignTimeServiceManager.columnDesignTimeService();
    private ActivityDesignTimeService activityService = DesignTimeServiceManager.activityDesignTimeService();

    @GetMapping(path={"/modules/{moduleId}/views"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u5217\u8868", notes="\u83b7\u53d6\u89c6\u56fe\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u5b57\u6216\u8005\u63cf\u8ff0\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="searchword", value="\u67e5\u8be2\u5173\u952e\u5b57", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="filterType", value="\u8fc7\u6ee4\u89c6\u56fe\u7c7b\u578b", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875\u6570", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u884c\u6570", required=true, paramType="query", dataType="int")})
    public Resource doGetViewList(@PathVariable String moduleId, @RequestParam(required=false) String searchword, String filterType, String pageNo, String linesPerPage) throws Exception {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        String[] filterTypes = null;
        if (!StringUtil.isBlank((String)filterType)) {
            filterTypes = filterType.split(",");
        }
        try {
            DataPackage views = this.viewService.queryByNameOrDescript(moduleId, searchword, page, line);
            Collection viewsList = views.getDatas();
            JSONArray viewArray = new JSONArray();
            block2: for (AbstractView view : viewsList) {
                if (filterTypes != null) {
                    for (int i = 0; i < filterTypes.length; ++i) {
                        if (view.getViewTypeImpl().intValue() == Integer.valueOf(filterTypes[i]).intValue()) continue block2;
                    }
                }
                String viewId = view.getId();
                String viewName = view.getName();
                String viewDescription = view.getDescription();
                JSONObject viewJson = new JSONObject();
                viewJson.put((Object)"id", (Object)viewId);
                viewJson.put((Object)"name", (Object)viewName);
                viewJson.put((Object)"description", (Object)viewDescription);
                viewJson.put((Object)"type", (Object)view.getViewTypeImpl().intValue());
                viewArray.add((Object)viewJson);
            }
            JSONObject viewsJson = new JSONObject();
            viewsJson.put((Object)"linesPerPage", (Object)views.getLinesPerPage());
            viewsJson.put((Object)"rowCount", (Object)views.getPageCount());
            viewsJson.put((Object)"pageNo", (Object)views.getPageNo());
            viewsJson.put((Object)"pageCount", (Object)views.getRowCount());
            viewsJson.put((Object)"datas", (Object)viewArray);
            return this.success("ok", viewsJson);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/views/{viewId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u8be6\u60c5", notes="\u83b7\u53d6\u89c6\u56fe\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string")})
    public Resource doGetViewDetailed(@PathVariable String viewId) throws Exception {
        try {
            AbstractView view = (AbstractView)this.viewService.findById(viewId);
            return this.success("ok", view);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/modules/views/copy"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u590d\u5236\u89c6\u56fe", notes="\u590d\u5236\u89c6\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCopyViews(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.viewService.doCopyView(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/{moduleId}/views"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u89c6\u56fe", notes="\u65b0\u5efa\u89c6\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewType", value="\u89c6\u56fe\u7c7b\u578b", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateView(@PathVariable String applicationId, @PathVariable String moduleId, @RequestParam int viewType, @RequestBody String content) throws Exception {
        try {
            ListView view = null;
            JSONObject json = JSONObject.fromObject((Object)content);
            switch (viewType) {
                case 1: {
                    view = (ListView)this.json2obj(json, ListView.class);
                    break;
                }
                case 18: {
                    view = (MapView)this.json2obj(json, MapView.class);
                    break;
                }
                case 17: {
                    view = (TreeView)this.json2obj(json, TreeView.class);
                    this.prepareTreeLinkJson((AbstractView)view);
                    break;
                }
                case 16: {
                    view = (CalendarView)this.json2obj(json, CalendarView.class);
                    break;
                }
                case 20: {
                    view = (CollapsibleView)this.json2obj(json, CollapsibleView.class);
                    break;
                }
                case 19: {
                    view = (GanttView)this.json2obj(json, GanttView.class);
                }
            }
            boolean validate = this.validate((AbstractView)view);
            if (!validate) {
                return this.error(500, "\u4fdd\u5b58\u5931\u8d25\uff0c\u5217\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u9519\u8bef", null);
            }
            if (view != null) {
                view.setApplicationid(applicationId);
                view.setParentId(moduleId);
                String viewId = Sequence.getDesignTimeSequence();
                view.setId(viewId);
                this.doSaveValidate((AbstractView)view);
                this.viewService.doCreate((AbstractView)view);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"id", (Object)viewId);
                return this.success("ok", jsonObject);
            }
            return this.error(500, "\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u76f8\u5173\u89c6\u56fe\u7c7b\u578b", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/modules/{moduleId}/views/{viewId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u89c6\u56fe", notes="\u66f4\u65b0\u89c6\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewType", value="\u89c6\u56fe\u7c7b\u578b", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateView(@PathVariable String applicationId, @PathVariable String moduleId, @PathVariable String viewId, @RequestParam int viewType, @RequestBody String content) throws Exception {
        try {
            ListView view = null;
            JSONObject json = JSONObject.fromObject((Object)content);
            json.remove("uri");
            switch (viewType) {
                case 1: {
                    view = (ListView)this.json2obj(json, ListView.class);
                    break;
                }
                case 18: {
                    view = (MapView)this.json2obj(json, MapView.class);
                    break;
                }
                case 17: {
                    view = (TreeView)this.json2obj(json, TreeView.class);
                    this.prepareTreeLinkJson((AbstractView)view);
                    break;
                }
                case 16: {
                    view = (CalendarView)this.json2obj(json, CalendarView.class);
                    break;
                }
                case 20: {
                    view = (CollapsibleView)this.json2obj(json, CollapsibleView.class);
                    break;
                }
                case 19: {
                    view = (GanttView)this.json2obj(json, GanttView.class);
                }
            }
            boolean validate = this.validate((AbstractView)view);
            if (!validate) {
                return this.error(500, "\u4fdd\u5b58\u5931\u8d25\uff0c\u5217\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u9519\u8bef", null);
            }
            if (view != null) {
                view.setApplicationid(applicationId);
                view.setParentId(moduleId);
                view.setId(viewId);
                view.setUri(view.getUri());
                this.doSaveValidate((AbstractView)view);
                this.viewService.saveOrUpdate((Object)view);
                return this.success("ok", null);
            }
            return this.error(500, "\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u76f8\u5173\u89c6\u56fe\u7c7b\u578b", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/views"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u89c6\u56fe", notes="\u5220\u9664\u89c6\u56fe\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteView(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.viewService.delete(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/modules/views"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u4e00\u952e\u751f\u6210\u89c6\u56fe", notes="\u4e00\u952e\u751f\u6210\u89c6\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="query", dataType="String")})
    public Resource doOneKeyCreateView(@RequestParam String formId) throws Exception {
        try {
            this.formService.oneKeyCreateView(formId);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/views/{viewId}/columns"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u5217\u5217\u8868", notes="\u83b7\u53d6\u89c6\u56fe\u5217\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string")})
    public Resource doGetViewColumnsList(@PathVariable String viewId) throws Exception {
        try {
            AbstractView view = (AbstractView)this.viewService.findById(viewId);
            view.setColumns(null);
            List columns = view.getColumns();
            JSONArray columnArray = new JSONArray();
            for (Column column : columns) {
                String columnId = column.getId();
                String columnName = column.getName();
                int columnOrderno = column.getOrderno();
                JSONObject columnJson = new JSONObject();
                columnJson.put((Object)"id", (Object)columnId);
                columnJson.put((Object)"name", (Object)columnName);
                columnJson.put((Object)"orderno", (Object)columnOrderno);
                columnArray.add((Object)columnJson);
            }
            return this.success("ok", columnArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/views/columns/{columnId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u5217\u8be6\u60c5", notes="\u83b7\u53d6\u89c6\u56fe\u5217\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="columnId", value="\u89c6\u56fe\u5217id", required=true, paramType="path", dataType="string")})
    public Resource doGetViewColumnsDetailed(@PathVariable String columnId) throws Exception {
        try {
            Column column = (Column)this.columnsService.findById(columnId);
            return this.success("ok", column);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/views/{viewId}/columns"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u89c6\u56fe\u5217", notes="\u65b0\u5efa\u89c6\u56fe\u5217")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateViewColumn(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Column column = (Column)this.json2obj(json, Column.class);
            if (column != null) {
                List columns = this.columnsService.queryAccurateByName(viewId, column.getName());
                if (columns.size() > 0) {
                    return this.error(500, "\u8be5\u5217\u540d\u79f0\u5df2\u5b58\u5728", null);
                }
                column.setApplicationid(applicationId);
                column.setParentId(viewId);
                String columnId = Sequence.getDesignTimeSequence();
                column.setId(columnId);
                this.columnsService.save((Object)column);
                JSONObject columnJson = new JSONObject();
                columnJson.put((Object)"id", (Object)columnId);
                return this.success("ok", columnJson);
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/views/{viewId}/columns/batch"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u6279\u91cf\u65b0\u5efa\u89c6\u56fe\u5217", notes="\u6279\u91cf\u65b0\u5efa\u89c6\u56fe\u5217")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateViewColumnBatch(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String content) throws Exception {
        try {
            JSONArray columnArray = JsonTmpUtil.fromObject((Object)content);
            JSONArray columnArray2 = new JSONArray();
            for (Object jsonArray : columnArray) {
                String columnContent = jsonArray.toString();
                JSONObject json = JSONObject.fromObject((Object)columnContent);
                Column column = (Column)this.json2obj(json, Column.class);
                if (column == null) continue;
                column.setApplicationid(applicationId);
                column.setParentId(viewId);
                String columnId = Sequence.getDesignTimeSequence();
                column.setId(columnId);
                this.columnsService.save((Object)column);
                JSONObject columnJson = new JSONObject();
                columnJson.put((Object)"id", (Object)columnId);
                columnArray2.add((Object)columnJson);
            }
            return this.success("ok", columnArray2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/modules/views/{viewId}/columns/{columnId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u89c6\u56fe\u5217", notes="\u66f4\u65b0\u89c6\u56fe\u5217")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="columnId", value="\u89c6\u56fe\u5217id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateViewColumn(@PathVariable String applicationId, @PathVariable String viewId, @PathVariable String columnId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Column column = (Column)this.json2obj(json, Column.class);
            if (column != null) {
                List columns = this.columnsService.queryAccurateByName(viewId, column.getName());
                for (Column c : columns) {
                    if (c.getId().equals(columnId)) continue;
                    return this.error(500, "\u8be5\u5217\u540d\u79f0\u5df2\u5b58\u5728", null);
                }
                column.setApplicationid(applicationId);
                column.setParentId(viewId);
                column.setId(columnId);
                column.setCustomIcon(((Boolean)json.get("customIcon")).booleanValue());
                this.columnsService.update((Object)column);
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/views/columns"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u89c6\u56fe\u5217", notes="\u5220\u9664\u89c6\u56fe\u5217\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteViewColumn(@RequestBody String content) throws Exception {
        try {
            List ids = (List)JsonPath.parse((String)content).json();
            String[] idArray = new String[]{};
            idArray = ids.toArray(idArray);
            this.columnsService.delete(idArray);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/views/{viewId}/activitys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u64cd\u4f5c\u5217\u8868", notes="\u83b7\u53d6\u89c6\u56fe\u64cd\u4f5c\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string")})
    public Resource doGetViewActivityList(@PathVariable String viewId) {
        try {
            AbstractView view = (AbstractView)this.viewService.findById(viewId);
            view.setActivities(null);
            List list = view.getActivities();
            return this.success("ok", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/modules/views/activitys/{activityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u89c6\u56fe\u64cd\u4f5c\u8be6\u60c5", notes="\u83b7\u53d6\u89c6\u56fe\u64cd\u4f5c\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="activityId", value="\u89c6\u56fe\u64cd\u4f5cid", required=true, paramType="path", dataType="string")})
    public Resource doGetViewActivity(@PathVariable String activityId) throws Exception {
        try {
            Activity activity = (Activity)this.activityService.findById(activityId);
            return this.success("ok", activity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/views/{viewId}/activitys"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u89c6\u56fe\u64cd\u4f5c", notes="\u65b0\u5efa\u89c6\u56fe\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateViewActivity(@PathVariable String applicationId, @PathVariable String viewId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Activity activity = (Activity)this.json2obj(json, Activity.class);
            List<Object> activities = new ArrayList();
            ActivityUtil activityUtil = new ActivityUtil();
            AbstractView view = (AbstractView)this.viewService.findById(viewId);
            if (!StringUtil.isBlank((String)view.getActivityXML())) {
                activities = activityUtil.parseXML(view.getActivityXML());
            }
            for (Activity act : activities) {
                if (act == null || !StringUtil.isBlank((String)activity.getId()) && act.getId().equals(activity.getId()) || !activity.getName().equals(act.getName())) continue;
                throw new Exception("\u8be5\u6309\u94ae\u540d\u79f0\u5df2\u5b58\u5728");
            }
            if (activity != null) {
                activity.setApplicationid(applicationId);
                activity.setParentView(viewId);
                activity.setParentId(viewId);
                String activityId = Sequence.getDesignTimeSequence();
                if (StringUtil.isBlank((String)activity.getId())) {
                    activity.setId(activityId);
                }
                this.activityService.saveOrUpdate((Object)activity);
                JSONObject columnJson = new JSONObject();
                columnJson.put((Object)"id", (Object)activityId);
                return this.success("ok", columnJson);
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/modules/views/{viewId}/activitys/{activityId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u89c6\u56fe\u64cd\u4f5c", notes="\u66f4\u65b0\u89c6\u56fe\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="viewId", value="\u89c6\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="activityId", value="\u89c6\u56fe\u64cd\u4f5cid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateViewActivity(@PathVariable String applicationId, @PathVariable String viewId, @PathVariable String activityId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Activity activity = (Activity)this.json2obj(json, Activity.class);
            if (activity != null) {
                activity.setApplicationid(applicationId);
                activity.setParentId(viewId);
                activity.setParentView(viewId);
                activity.setId(activityId);
                this.activityService.update((Object)activity);
            }
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/modules/views/activitys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u89c6\u56fe\u64cd\u4f5c", notes="\u5220\u9664\u89c6\u56fe\u64cd\u4f5c\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteViewActivity(@RequestBody String[] ids) {
        try {
            this.activityService.delete(ids);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/getFormValueStoreFields/{formId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6765\u6e90\u8868\u5355\u5b57\u6bb5\uff08\u5305\u542b\u7cfb\u7edf\u53d8\u91cf\uff09", notes="\u83b7\u53d6\u6570\u636e\u6765\u6e90\u8868\u5355\u5b57\u6bb5\uff08\u5305\u542b\u7cfb\u7edf\u53d8\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource getFormValueStoreFields(@PathVariable String formId) {
        try {
            FormHelper formHelper = new FormHelper();
            Map map = formHelper.getValueStoreFields(formId);
            return this.success("ok", map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/getSystemScreeningFields/{formId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u89c6\u56fe\u83b7\u53d6\u7cfb\u7edf\u7b5b\u9009\u5b57\u6bb5", notes="\u89c6\u56fe\u83b7\u53d6\u7cfb\u7edf\u7b5b\u9009\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u6570\u636e\u6765\u6e90\u8868\u5355id", required=true, paramType="path", dataType="string")})
    public Resource getSystemScreeningFields(@PathVariable String formId) {
        Map<Object, Object> map = new LinkedHashMap();
        try {
            ViewHelper viewHelper = new ViewHelper();
            map = viewHelper.createFieldOptions(formId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", map);
    }

    @GetMapping(path={"/getScopeByField/{authField}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u7b5b\u9009\u5b57\u6bb5\u83b7\u53d6\u4f5c\u7528\u57df", notes="\u6839\u636e\u7b5b\u9009\u5b57\u6bb5\u83b7\u53d6\u4f5c\u7528\u57df")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authField", value="\u9009\u4e2d\u7684\u7b5b\u9009\u5b57\u6bb5", required=true, paramType="path", dataType="string")})
    public Resource getScopeByField(@PathVariable String authField) {
        Map<Object, Object> map = new LinkedHashMap();
        try {
            ViewHelper viewHelper = new ViewHelper();
            map = viewHelper.createAuthFieldOptions("", authField, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", map);
    }

    @PutMapping(path={"/views/column/order"})
    @ApiOperation(value="\u89c6\u56fe\u5217\u6392\u5e8f\u4fee\u6539", notes="\u89c6\u56fe\u5217\u6392\u5e8f\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oId", value="\u9009\u4e2d\u7684\u5217id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nId", value="\u4e92\u6362\u7684\u5217id", required=true, paramType="query", dataType="string")})
    public Resource updateColumnOrder(@RequestParam String oId, @RequestParam String nId) {
        try {
            Column o = (Column)this.columnsService.findById(oId);
            Column n = (Column)this.columnsService.findById(nId);
            int tempOrder = o.getOrderno();
            o.setOrderno(n.getOrderno());
            n.setOrderno(tempOrder);
            this.columnsService.update((Object)o);
            this.columnsService.update((Object)n);
            return this.success("ok", "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/activity/order"})
    @ApiOperation(value="\u64cd\u4f5c\u5217\u8868\u6392\u5e8f\u4fee\u6539", notes="\u64cd\u4f5c\u5217\u8868\u6392\u5e8f\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oId", value="\u9009\u4e2d\u64cd\u4f5c\u6309\u94aeid", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nId", value="\u4e92\u6362\u64cd\u4f5c\u6309\u94aeid", required=true, paramType="query", dataType="string")})
    public Resource updateActivityOrder(@RequestParam String oId, @RequestParam String nId) {
        try {
            Activity o = (Activity)this.activityService.findById(oId);
            Activity n = (Activity)this.activityService.findById(nId);
            int tempOrder = o.getOrderno();
            o.setOrderno(n.getOrderno());
            n.setOrderno(tempOrder);
            this.activityService.update((Object)o);
            this.activityService.update((Object)n);
            return this.success("ok", "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(AbstractView view) throws Exception {
        Collection tempViews = this.viewService.queryByNameAndModule(view.getName(), view.getParentId());
        if (tempViews != null && !tempViews.isEmpty()) {
            AbstractView tempView = (AbstractView)tempViews.iterator().next();
            if (view.getId() == null || view.getId().trim().length() <= 0) {
                throw new OBPMValidateException("{*[viewExist]*}");
            }
            if (!view.getId().trim().equalsIgnoreCase(tempView.getId())) {
                throw new OBPMValidateException("{*[viewExist]*}");
            }
        }
    }

    private void prepareTreeLinkJson(AbstractView view) throws Exception {
        LinkDesignTimeService linkDesignTimeService;
        LinkVO linkVO;
        String nodeLinkId = ((TreeView)view).getNodeLinkId();
        if (!StringUtil.isBlank((String)nodeLinkId) && (linkVO = (LinkVO)(linkDesignTimeService = DesignTimeServiceManager.linkDesignTimeService()).findById(nodeLinkId)) != null) {
            JSONObject link = new JSONObject();
            link.put((Object)"id", (Object)linkVO.getId());
            link.put((Object)"name", (Object)linkVO.getName());
            link.put((Object)"type", (Object)linkVO.getType());
            link.put((Object)"actionContent", (Object)linkVO.getActionContent());
            link.put((Object)"applicationid", (Object)linkVO.getApplicationid());
            link.put((Object)"queryString", (Object)("\"" + linkVO.getQueryString() + "\""));
            ((TreeView)view).setLinkVoJson(link.toString());
        }
    }

    private boolean validate(AbstractView view) {
        List columns = view.getColumns();
        int count = 0;
        for (Column column : columns) {
            String mappingField = column.getMappingField();
            if (StringUtil.isBlank((String)mappingField)) continue;
            ++count;
        }
        switch (view.getIntValue()) {
            case 1: {
                break;
            }
            case 17: 
            case 18: {
                if (count >= 3) break;
                return false;
            }
            case 16: {
                if (count >= 1) break;
                return false;
            }
            case 20: {
                break;
            }
            case 19: {
                if (count >= 4) break;
                return false;
            }
        }
        return true;
    }
}

