/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.versions.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.versions.service.VersionsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u516c\u5171\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime"}, produces={"application/json;charset=UTF-8"})
public class VersionsController
extends AbstractDesignTimeController {
    private VersionsService versionsService = DesignTimeServiceManager.versionsService();

    @GetMapping(path={"/systeminfo"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\u5217\u8868\uff08\u53ef\u6839\u636e\u540d\u79f0\u6216\u8005\u7c7b\u578b\u67e5\u8be2\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="currpage", value="\u5f53\u524d\u9875\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="pagelines", value="\u6bcf\u9875\u884c\u6570", required=true, paramType="query", dataType="string")})
    public Resource doGetVersionsList(@RequestParam(required=false) String name, @RequestParam(required=false, defaultValue="0") int type, String currpage, String pagelines) throws Exception {
        int page = currpage != null && currpage.length() > 0 ? Integer.parseInt(currpage) : 1;
        int line = pagelines != null && pagelines.length() > 0 ? Integer.parseInt(pagelines) : 10;
        try {
            DataPackage versions = this.versionsService.query(null, name, type == 0 ? null : Integer.valueOf(type), page, line);
            return this.success("ok", versions);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

