/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.permission.controller;

import cn.myapps.common.Environment;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.permission.Permission;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.module.service.ModuleDesignTimeService;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u89d2\u8272\u6388\u6743\u8bbe\u8ba1\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime"}, produces={"application/json;charset=UTF-8"})
public class PermissionDesigntimeConrtroller
extends AbstractDesignTimeController {
    @PostMapping(value={"/applications/{applicationId}/permissions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u6388\u6743\u914d\u7f6e", notes="\u6279\u91cf\u66f4\u65b0\u6388\u6743\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public Resource batchGrant(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            List roleIds = (List)json.get("roles");
            List resources = (List)json.get("resources");
            List views = (List)json.get("views");
            List forms = (List)json.get("forms");
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            if (roleIds != null) {
                for (String roleId : roleIds) {
                    Permission permission;
                    boolean checked;
                    String activityId;
                    Role role = (Role)roleDesignTimeService.findById(roleId);
                    ArrayList<String> removeResIdList = new ArrayList<String>();
                    ArrayList<Permission> permissionList = new ArrayList<Permission>();
                    if (resources != null) {
                        for (JSONObject resourceJson : resources) {
                            String resourceId = (String)resourceJson.get("id");
                            removeResIdList.add(resourceId);
                            boolean checked2 = resourceJson.getBoolean("checked");
                            if (!checked2) continue;
                            Permission permission2 = PermissionUtil.createPermissionResource((String)roleId, (String)resourceId);
                            permissionList.add(permission2);
                        }
                    }
                    for (JSONObject viewJson : views) {
                        String viewId = (String)viewJson.get("id");
                        List activities = (List)viewJson.get("activities");
                        if (activities == null) continue;
                        removeResIdList.add(viewId);
                        for (JSONObject activityJson : activities) {
                            activityId = (String)activityJson.get("id");
                            checked = activityJson.getBoolean("checked");
                            if (!checked) continue;
                            permission = PermissionUtil.createPermission((String)viewId, (String)activityId, (Integer)0, (String)roleId);
                            permissionList.add(permission);
                        }
                    }
                    for (JSONObject formJson : forms) {
                        String formId = (String)formJson.get("id");
                        List activities = (List)formJson.get("activities");
                        if (activities == null) continue;
                        removeResIdList.add(formId);
                        for (JSONObject activityJson : activities) {
                            activityId = (String)activityJson.get("id");
                            checked = activityJson.getBoolean("checked");
                            if (!checked) continue;
                            permission = PermissionUtil.createPermission((String)formId, (String)activityId, (Integer)1, (String)roleId);
                            permissionList.add(permission);
                        }
                    }
                    if (role == null) continue;
                    PermissionUtil.removeAuth(removeResIdList, (Role)role);
                    PermissionUtil.pushAuth(permissionList, (Role)role);
                    roleDesignTimeService.update((Object)role);
                }
            }
            Environment.cleanPermissionMap();
            PermissionUtil.initPermissionMap();
            return this.success("ok", "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/permissions/pc"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u67e5\u8be2pc\u83dc\u5355\u914d\u7f6e\u8d44\u6e90\u5217\u8868", notes="\u67e5\u8be2pc\u83dc\u5355\u914d\u7f6e\u8d44\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u83dc\u5355id", required=false, paramType="query", dataType="string")})
    public Resource getPcPermissionByRole(@PathVariable String applicationId, @RequestParam(required=false) String roleId, @RequestParam(required=false) String parentId) {
        try {
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            Role role = (Role)roleDesignTimeService.findById(roleId);
            List allResources = rp.deepQueryAll(applicationId, "menu");
            ArrayList<ResourceVO> resources = new ArrayList<ResourceVO>();
            for (ResourceVO r : allResources) {
                if (!r.getUri().endsWith(".menu")) continue;
                resources.add(r);
            }
            JSONArray result = new JSONArray();
            for (ResourceVO resourceVO : resources) {
                if (StringUtil.isBlank((String)parentId)) {
                    parentId = applicationId;
                }
                if (!parentId.equals(resourceVO.getParentId())) continue;
                JSONObject json = new JSONObject();
                json.put((Object)"id", (Object)resourceVO.getId());
                json.put((Object)"parentId", (Object)resourceVO.getParentId());
                json.put((Object)"name", (Object)resourceVO.getName());
                String permissionType = resourceVO.getPermissionType();
                json.put((Object)"permissionType", (Object)permissionType);
                if ("public".equals(permissionType) || StringUtil.isBlank((String)roleId)) {
                    json.put((Object)"checked", (Object)true);
                } else {
                    boolean checked = PermissionUtil.isExist((Role)role, (String)resourceVO.getId());
                    if (checked) {
                        json.put((Object)"checked", (Object)true);
                    } else {
                        json.put((Object)"checked", (Object)false);
                    }
                }
                List subResources = rp.list(resourceVO.getId(), null);
                if (subResources != null && !subResources.isEmpty()) {
                    json.put((Object)"hasChild", (Object)true);
                } else {
                    json.put((Object)"hasChild", (Object)false);
                }
                result.add((Object)json);
            }
            return this.success("ok", result);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/permissions/mobile"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u67e5\u8be2mobile\u83dc\u5355\u914d\u7f6e\u8d44\u6e90\u5217\u8868", notes="\u67e5\u8be2mobile\u83dc\u5355\u914d\u7f6e\u8d44\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u83dc\u5355id", required=false, paramType="query", dataType="string")})
    public Resource getMobilePermissionByRole(@PathVariable String applicationId, @RequestParam(required=false) @PathVariable String roleId, @RequestParam(required=false) String parentId) {
        try {
            ResourceDesignTimeService rp = DesignTimeServiceManager.resourceDesignTimeService();
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            Role role = (Role)roleDesignTimeService.findById(roleId);
            List resources = rp.deepQueryAll(applicationId, "mobilemenu");
            JSONArray result = new JSONArray();
            for (ResourceVO resourceVO : resources) {
                if (StringUtil.isBlank((String)parentId)) {
                    parentId = applicationId;
                }
                if (!parentId.equals(resourceVO.getParentId())) continue;
                JSONObject json = new JSONObject();
                json.put((Object)"id", (Object)resourceVO.getId());
                json.put((Object)"parentId", (Object)resourceVO.getParentId());
                json.put((Object)"name", (Object)resourceVO.getName());
                String permissionType = resourceVO.getPermissionType();
                json.put((Object)"permissionType", (Object)permissionType);
                if ("public".equals(permissionType) || StringUtil.isBlank((String)roleId)) {
                    json.put((Object)"checked", (Object)true);
                } else {
                    boolean checked = PermissionUtil.isExist((Role)role, (String)resourceVO.getId());
                    if (checked) {
                        json.put((Object)"checked", (Object)true);
                    } else {
                        json.put((Object)"checked", (Object)false);
                    }
                }
                List subResources = rp.list(resourceVO.getId(), "mobilemenu", "mobilemenu", null);
                if (subResources != null && !subResources.isEmpty()) {
                    json.put((Object)"hasChild", (Object)true);
                } else {
                    json.put((Object)"hasChild", (Object)false);
                }
                result.add((Object)json);
            }
            return this.success("ok", result);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/permissions/module"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u914d\u7f6e\u8d44\u6e90\u5217\u8868", notes="\u67e5\u8be2\u6a21\u5757\u914d\u7f6e\u8d44\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u83dc\u5355id", required=true, paramType="query", dataType="string")})
    public Resource getModulePermissionByRole(@PathVariable String applicationId, @RequestParam(required=false) String parentId) {
        try {
            ModuleDesignTimeService moduleService = DesignTimeServiceManager.moduleDesignTimeService();
            List modules = moduleService.list(applicationId, null);
            JSONArray result = new JSONArray();
            for (Module module : modules) {
                if (StringUtil.isBlank((String)parentId)) {
                    parentId = applicationId;
                }
                if (!parentId.equals(module.getParentId())) continue;
                JSONObject json = new JSONObject();
                json.put((Object)"id", (Object)module.getId());
                json.put((Object)"parentId", (Object)module.getParentId());
                json.put((Object)"name", (Object)module.getName());
                List subModules = moduleService.list(module.getId(), null);
                if (subModules != null && !subModules.isEmpty()) {
                    json.put((Object)"hasChild", (Object)true);
                } else {
                    json.put((Object)"hasChild", (Object)false);
                }
                result.add((Object)json);
            }
            return this.success("ok", result);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/applications/{applicationId}/modules/{moduleId}/permissions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u67e5\u8be2\u6240\u5c5e\u6a21\u5757\u7684\u8868\u5355\u6216\u89c6\u56fe\u914d\u7f6e\u8d44\u6e90\u5217\u8868", notes="\u67e5\u8be2\u6240\u5c5e\u6a21\u5757\u7684\u8868\u5355\u6216\u89c6\u56fe\u914d\u7f6e\u8d44\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string")})
    public Resource getModulePermissionByRole(@PathVariable String applicationId, @RequestParam(required=false) @PathVariable String roleId, @PathVariable String moduleId) {
        try {
            JSONObject result = new JSONObject();
            RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
            Role role = (Role)roleDesignTimeService.findById(roleId);
            FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
            Collection forms = fp.getFormsByModule(moduleId, applicationId);
            JSONArray formArr = new JSONArray();
            for (Form form : forms) {
                JSONObject formJson = new JSONObject();
                formJson.put((Object)"id", (Object)form.getId());
                String name = "";
                name = !StringUtil.isBlank((String)form.getDescription()) ? form.getDescription() : form.getName();
                formJson.put((Object)"name", (Object)name);
                String permissionType = form.getPermissionType();
                formJson.put((Object)"permissionType", (Object)permissionType);
                List orginActivities = form.getActivities();
                ArrayList<Activity> activities = new ArrayList<Activity>();
                activities.addAll(orginActivities);
                Activity open = new Activity();
                open.setId(form.getId());
                open.setName("\u6253\u5f00");
                activities.add(open);
                JSONArray activityArr = new JSONArray();
                for (Activity activity : activities) {
                    JSONObject activityJson = new JSONObject();
                    activityJson.put((Object)"id", (Object)activity.getId());
                    activityJson.put((Object)"name", (Object)activity.getName());
                    if ("public".equals(permissionType) || StringUtil.isBlank((String)roleId)) {
                        activityJson.put((Object)"checked", (Object)true);
                    } else {
                        boolean checked = PermissionUtil.isExist((Role)role, (String)activity.getId());
                        if (checked) {
                            activityJson.put((Object)"checked", (Object)true);
                        } else {
                            activityJson.put((Object)"checked", (Object)false);
                        }
                    }
                    activityArr.add((Object)activityJson);
                }
                formJson.put((Object)"activities", (Object)activityArr);
                formArr.add((Object)formJson);
            }
            result.put((Object)"forms", (Object)formArr);
            ViewDesignTimeService vp = DesignTimeServiceManager.viewDesignTimeService();
            Collection views = vp.getViewsByModule(moduleId, applicationId);
            JSONArray viewArr = new JSONArray();
            for (AbstractView view : views) {
                JSONObject viewJson = new JSONObject();
                viewJson.put((Object)"id", (Object)view.getId());
                String name = "";
                name = !StringUtil.isBlank((String)view.getDescription()) ? view.getDescription() : view.getName();
                viewJson.put((Object)"name", (Object)name);
                String permissionType = view.getPermissionType();
                viewJson.put((Object)"permissionType", (Object)permissionType);
                List orginActivities = view.getActivities();
                ArrayList<Activity> activities = new ArrayList<Activity>();
                activities.addAll(orginActivities);
                Activity open = new Activity();
                open.setId(view.getId());
                open.setName("\u6253\u5f00");
                activities.add(open);
                JSONArray activityArr = new JSONArray();
                for (Activity activity : activities) {
                    JSONObject activityJson = new JSONObject();
                    activityJson.put((Object)"id", (Object)activity.getId());
                    activityJson.put((Object)"name", (Object)activity.getName());
                    if ("public".equals(permissionType) || StringUtil.isBlank((String)roleId)) {
                        activityJson.put((Object)"checked", (Object)true);
                    } else {
                        boolean checked = PermissionUtil.isExist((Role)role, (String)activity.getId());
                        if (checked) {
                            activityJson.put((Object)"checked", (Object)true);
                        } else {
                            activityJson.put((Object)"checked", (Object)false);
                        }
                    }
                    activityArr.add((Object)activityJson);
                }
                viewJson.put((Object)"activities", (Object)activityArr);
                viewArr.add((Object)viewJson);
            }
            result.put((Object)"views", (Object)viewArr);
            return this.success("ok", result);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }
}

