/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.validaterepository.ValidateRepositoryVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.validate.repository.service.ValidateRepositoryDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.List;

public class ValidateReposityOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell vc = new Cell();
            vc.setBackgroundColor(Color.gray);
            vc.addElement((Element)new Paragraph("\u6821\u9a8c\u5e93\uff1a", fontChinese));
            table.addCell(vc);
            vc = new Cell();
            ValidateRepositoryDesignTimeService vrp = DesignTimeServiceManager.validateRepositoryDesignTimeService();
            List validateRepositories = vrp.list(applicationId, null);
            if (validateRepositories != null && validateRepositories.size() > 0) {
                Table vrTable = new Table(2);
                vrTable.setPadding(0.0f);
                vrTable.setSpacing(0.0f);
                vrTable.setBorderWidth(1.0f);
                vrTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                vrTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u7248\u672c", fontChinese));
                vrTable.addCell(cell);
                for (ValidateRepositoryVO validateRepository : validateRepositories) {
                    cell = new Cell();
                    String vrName = validateRepository.getName();
                    cell.addElement((Element)new Paragraph(vrName != null ? vrName : "", fontChinese));
                    vrTable.addCell(cell);
                    cell = new Cell();
                    int version = validateRepository.getVersion();
                    cell.addElement((Element)new Paragraph(String.valueOf(version), fontChinese));
                    vrTable.addCell(cell);
                    cell = new Cell();
                    cell.setColspan(2);
                    String content = validateRepository.getContent();
                    cell.addElement((Element)new Paragraph("\u5185\u5bb9\uff1a\n" + (content != null ? content : ""), fontChinese));
                    vrTable.addCell(cell);
                }
                vc.addElement((Element)vrTable);
                table.addCell(vc);
            }
        }
        return table;
    }
}

