/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.task.Task;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.overview.IOverview;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TaskOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell tc = new Cell();
            tc.setBackgroundColor(Color.gray);
            tc.addElement((Element)new Paragraph("\u4efb\u52a1\uff1a", fontChinese));
            table.addCell(tc);
            TaskDesignTimeService tp = DesignTimeServiceManager.taskDesignTimeService();
            List tasks = tp.list(applicationId, null);
            if (tasks != null) {
                tc = new Cell();
                Iterator it = tasks.iterator();
                Table tTable = new Table(1);
                tTable.setWidth(99.0f);
                tTable.setPadding(0.0f);
                tTable.setSpacing(0.0f);
                tTable.setBorderWidth(0.0f);
                while (it.hasNext()) {
                    String terminalScript;
                    Task task = (Task)it.next();
                    Cell tCell = new Cell();
                    tCell.setBorderWidth(0.0f);
                    Table tt = new Table(3);
                    tt.setWidth(99.0f);
                    tt.setPadding(0.0f);
                    tt.setSpacing(0.0f);
                    tt.setBorderWidth(0.0f);
                    Cell cell = new Cell();
                    cell.setBorderWidth(0.0f);
                    cell.setColspan(3);
                    String tName = task.getName();
                    cell.addElement((Element)new Paragraph("\u4efb\u52a1\u540d\u79f0\uff1a" + (tName != null ? tName : ""), fontChinese));
                    String creator = task.getCreator();
                    cell.addElement((Element)new Paragraph("\u521b\u5efa\u4eba\uff1a" + (creator != null ? creator : ""), fontChinese));
                    String description = task.getDescription();
                    cell.addElement((Element)new Paragraph("\u63cf\u8ff0\uff1a" + (description != null ? description : ""), fontChinese));
                    tt.addCell(cell);
                    cell = new Cell();
                    cell.setBackgroundColor(Color.gray);
                    cell.addElement((Element)new Paragraph("\u7c7b\u578b", fontChinese));
                    tt.addCell(cell);
                    cell = new Cell();
                    cell.setBackgroundColor(Color.gray);
                    cell.addElement((Element)new Paragraph("\u542f\u52a8\u7c7b\u578b", fontChinese));
                    tt.addCell(cell);
                    cell = new Cell();
                    cell.setBackgroundColor(Color.gray);
                    cell.addElement((Element)new Paragraph("\u91cd\u590d", fontChinese));
                    tt.addCell(cell);
                    int type = task.getType();
                    cell = new Cell();
                    if (1 == type) {
                        cell.addElement((Element)new Paragraph("\u811a\u672c", fontChinese));
                    }
                    tt.addCell(cell);
                    int startTime = task.getStartupType();
                    HashMap<Integer, String> sMap = new HashMap<Integer, String>();
                    sMap.put(0, "\u624b\u52a8");
                    sMap.put(1, "\u81ea\u52a8");
                    sMap.put(2, "\u7981\u6b62");
                    String st = (String)sMap.get(startTime);
                    cell = new Cell();
                    if (!StringUtil.isBlank((String)st)) {
                        cell.addElement((Element)new Paragraph(st, fontChinese));
                    }
                    tt.addCell(cell);
                    int period = task.getPeriod();
                    HashMap<Integer, String> pMap = new HashMap<Integer, String>();
                    pMap.put(2, "\u6bcf\u5929");
                    pMap.put(34, "\u6bcf\u5206");
                    pMap.put(546, "\u6bcf\u65f6");
                    pMap.put(32, "\u6bcf\u5468");
                    pMap.put(512, "\u6bcf\u6708");
                    pMap.put(8192, "\u7acb\u523b");
                    pMap.put(0, "\u4e0d\u91cd\u590d");
                    String p = (String)pMap.get(period);
                    cell = new Cell();
                    if (!StringUtil.isBlank((String)p)) {
                        cell.addElement((Element)new Paragraph(p, fontChinese));
                    }
                    tt.addCell(cell);
                    String content = task.getTaskScript();
                    if (!StringUtil.isBlank((String)content)) {
                        cell = new Cell();
                        cell.addElement((Element)new Paragraph("\u4efb\u52a1\u5185\u5bb9\uff1a\n" + StringUtil.dencodeHTML((String)content), fontChinese));
                        tt.addCell(cell);
                    }
                    if (!StringUtil.isBlank((String)(terminalScript = task.getTerminateScript()))) {
                        cell = new Cell();
                        cell.addElement((Element)new Paragraph("\u7ec8\u6b62\u6761\u4ef6\uff1a\n" + StringUtil.dencodeHTML((String)terminalScript), fontChinese));
                        tt.addCell(cell);
                    }
                    tCell.addElement((Element)tt);
                    tTable.addCell(tCell);
                }
                tc.addElement((Element)tTable);
                table.addCell(tc);
            }
        }
        return table;
    }
}

