/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.macrorepository.RepositoryVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.macro.repository.service.RepositoryDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.List;

public class ReposityOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell rc = new Cell();
            rc.setBackgroundColor(Color.gray);
            rc.addElement((Element)new Paragraph("\u51fd\u6570\u5e93\uff1a", fontChinese));
            table.addCell(rc);
            rc = new Cell();
            RepositoryDesignTimeService rp = DesignTimeServiceManager.repositoryDesignTimeService();
            List repositories = rp.list(applicationId, null);
            if (repositories != null && repositories.size() > 0) {
                Table rTable = new Table(2);
                rTable.setPadding(0.0f);
                rTable.setSpacing(0.0f);
                rTable.setBorderWidth(1.0f);
                rTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                rTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u7248\u672c", fontChinese));
                rTable.addCell(cell);
                for (RepositoryVO repository : repositories) {
                    cell = new Cell();
                    String rName = repository.getName();
                    cell.addElement((Element)new Paragraph(rName != null ? rName : "", fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    int version = repository.getVersion();
                    cell.addElement((Element)new Paragraph(String.valueOf(version), fontChinese));
                    rTable.addCell(cell);
                    cell = new Cell();
                    cell.setColspan(2);
                    String content = repository.getContent();
                    cell.addElement((Element)new Paragraph("\u5185\u5bb9\uff1a\n" + (content != null ? content : ""), fontChinese));
                    rTable.addCell(cell);
                }
                rc.addElement((Element)rTable);
                table.addCell(rc);
            }
        }
        return table;
    }
}

