/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.overview.IOverview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OverviewFactory {
    public static final String APPLICATION_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.ApplicationOverview";
    public static final String DATASOURCE_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.DataSourceOverview";
    public static final String FORM_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.FormOverview";
    public static final String VIEW_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.ViewOverview";
    public static final String WORKFLOW_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.WorkFlowOverview";
    public static final String REPORT_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.ReportOverview";
    public static final String TASK_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.TaskOverview";
    public static final String ROLE_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.RoleOverview";
    public static final String MENU_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.MenuOverview";
    public static final String MOBILEMENU_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.MobileMenuOverview";
    public static final String STATELABEL_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.StateLabelOverview";
    public static final String REPOSITY_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.ReposityOverview";
    public static final String STYLEREPOSITY_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.StyleReposityOverview";
    public static final String VALIDATEREPOSITY_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.ValidateReposityOverview";
    public static final String DEVELOPER_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.DeveloperOverview";
    public static final String EXCELIMPORT_OVERVIEW_CLASSNAME = "cn.myapps.designtime.overview.ExcelImportConfigOverview";
    private static final Map<String, String> classNames = new LinkedHashMap<String, String>();

    public static void put(String key, String className) {
        classNames.put(key, className);
    }

    public static void putAll(Map<String, String> m) {
        classNames.putAll(m);
    }

    public static void remove(String key) {
        classNames.remove(key);
    }

    public static Collection<IOverview> createAllOverview() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ArrayList<IOverview> overviews = new ArrayList<IOverview>();
        Iterator<Map.Entry<String, String>> it = classNames.entrySet().iterator();
        if (it != null) {
            while (it.hasNext()) {
                Object instance;
                Class<?> clazz;
                String className;
                Map.Entry<String, String> entry = it.next();
                if (entry == null || StringUtil.isBlank((String)(className = entry.getValue())) || (clazz = Class.forName(className)) == null || !((instance = clazz.newInstance()) instanceof IOverview)) continue;
                overviews.add((IOverview)instance);
            }
        }
        return overviews;
    }

    public static Collection<IOverview> createOverview(Collection<String> classNames) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Iterator<String> it;
        ArrayList<IOverview> overviews = new ArrayList<IOverview>();
        if (classNames != null && (it = classNames.iterator()) != null) {
            while (it.hasNext()) {
                Object instance;
                String className = it.next();
                Class<?> clazz = Class.forName(className);
                if (clazz == null || !((instance = clazz.newInstance()) instanceof IOverview)) continue;
                overviews.add((IOverview)instance);
            }
        }
        return overviews;
    }

    static {
        classNames.put("APPLICATION", APPLICATION_OVERVIEW_CLASSNAME);
        classNames.put("DATASOURCE", DATASOURCE_OVERVIEW_CLASSNAME);
        classNames.put("FORM", FORM_OVERVIEW_CLASSNAME);
        classNames.put("VIEW", VIEW_OVERVIEW_CLASSNAME);
        classNames.put("WORKFLOW", WORKFLOW_OVERVIEW_CLASSNAME);
        classNames.put("REPORT", REPORT_OVERVIEW_CLASSNAME);
        classNames.put("TASK", TASK_OVERVIEW_CLASSNAME);
        classNames.put("ROLE", ROLE_OVERVIEW_CLASSNAME);
        classNames.put("MENU", MENU_OVERVIEW_CLASSNAME);
        classNames.put("MOBILEMENU", MOBILEMENU_OVERVIEW_CLASSNAME);
        classNames.put("STATELABEL", STATELABEL_OVERVIEW_CLASSNAME);
        classNames.put("REPOSITY", REPOSITY_OVERVIEW_CLASSNAME);
        classNames.put("STYLEREPOSITY", STYLEREPOSITY_OVERVIEW_CLASSNAME);
        classNames.put("VALIDATEREPOSITY", VALIDATEREPOSITY_OVERVIEW_CLASSNAME);
        classNames.put("DEVELOPER", DEVELOPER_OVERVIEW_CLASSNAME);
        classNames.put("EXCELIMPORT", EXCELIMPORT_OVERVIEW_CLASSNAME);
    }
}

