/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.overview;

import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.dts.excelimport.config.service.IMPMappingConfigDesignTimeService;
import cn.myapps.designtime.overview.IOverview;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.List;

public class ExcelImportConfigOverview
implements IOverview {
    @Override
    public Table buildOverview(String applicationId) throws Exception {
        Table table = new Table(1);
        table.setPadding(2.0f);
        table.setSpacing(0.0f);
        table.setBorderWidth(1.0f);
        table.setWidth(100.0f);
        if (!StringUtil.isBlank((String)applicationId)) {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            Font fontChinese = new Font(bfChinese, 10.0f, 0, Color.BLACK);
            Cell ec = new Cell();
            ec.setBackgroundColor(Color.gray);
            ec.addElement((Element)new Paragraph("Excel\u5bfc\u5165\u914d\u7f6e\uff1a", fontChinese));
            table.addCell(ec);
            IMPMappingConfigDesignTimeService impp = DesignTimeServiceManager.impMappingConfigDesignTimeService();
            List impMappingConfigs = impp.list(applicationId, null);
            if (impMappingConfigs != null && impMappingConfigs.size() > 0) {
                ec = new Cell();
                Table impTable = new Table(2);
                impTable.setPadding(0.0f);
                impTable.setSpacing(0.0f);
                impTable.setBorderWidth(1.0f);
                impTable.setWidth(96.0f);
                Cell cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u540d\u79f0", fontChinese));
                impTable.addCell(cell);
                cell = new Cell();
                cell.setBackgroundColor(Color.gray);
                cell.addElement((Element)new Paragraph("\u4e0a\u4f20\u6a21\u677f", fontChinese));
                impTable.addCell(cell);
                for (IMPMappingConfigVO impc : impMappingConfigs) {
                    if (impc == null) continue;
                    cell = new Cell();
                    String impName = impc.getName();
                    cell.addElement((Element)new Paragraph(impName != null ? impName : "", fontChinese));
                    impTable.addCell(cell);
                    cell = new Cell();
                    String impPath = impc.getPath();
                    cell.addElement((Element)new Paragraph(impPath != null ? impPath : "", fontChinese));
                    impTable.addCell(cell);
                    String xml = impc.getXml();
                    if (StringUtil.isBlank((String)xml)) continue;
                    cell = new Cell();
                    cell.setColspan(2);
                    cell.addElement((Element)new Paragraph("\u4ee3\u7801\uff1a\n" + (xml != null ? xml : ""), fontChinese));
                    impTable.addCell(cell);
                }
                ec.addElement((Element)impTable);
                table.addCell(ec);
            }
        }
        return table;
    }
}

