/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.login.controller;

import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Base64Util;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
@RequestMapping(value={"/api/designtime"})
@Scope(value="prototype")
public class LoginDesignTimeController
extends AbstractDesignTimeController {
    private String CheckCode_Session = "CheckCode";
    private static int WIDTH = 60;
    private static int HEIGHT = 20;

    @PostMapping(value={"/login"})
    @ApiOperation(value="designer\u767b\u9646", notes="designer\u767b\u9646")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u767b\u9646\u6570\u636e\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource login(@RequestBody String content) {
        int count = 0;
        SuperUserDesignTimeService superProcess = null;
        SuperUserVO originUser = null;
        String png_base64 = "";
        try {
            String code;
            JSONObject json = JSONObject.fromObject((Object)content);
            String username = (String)json.get("username");
            String password = (String)json.get("password");
            String checkcode = json.getString("checkcode");
            if (password != null && password.length() > 2) {
                String lp = password.substring(0, password.length() - 2);
                String rp = password.substring(password.length() - 2, password.length());
                password = Security.decodeBASE64((String)(rp + lp));
            }
            if ((count = (originUser = (superProcess = DesignTimeServiceManager.superUserDesignTimeService()).doViewByLoginno(username)).getPwdErrorTimes()) > 2 && (code = (String)this.request.getSession().getAttribute(this.CheckCode_Session)) != null && !code.equalsIgnoreCase(checkcode)) {
                png_base64 = "data:image/jpg;base64," + this.getCheckCodeImg();
                JSONObject result = new JSONObject();
                result.put((Object)"checkcodeImg", (Object)png_base64);
                return this.error(1, "\u8f93\u5165\u5b57\u7b26\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u56fe\u7247\u4e2d\u51fa\u73b0\u76844\u4e2a\u5b57\u7b26", result, null);
            }
            if (count >= 2) {
                png_base64 = "data:image/jpg;base64," + this.getCheckCodeImg();
            }
            SuperUserVO user = superProcess.login(username, password);
            String token = null;
            if (user == null || user.getStatus() != 1) {
                if (originUser != null) {
                    originUser.setPwdErrorTimes(++count);
                    if (count > 10) {
                        originUser.setStatus(0);
                    }
                    superProcess.doUpdate(originUser);
                }
                JSONObject result = new JSONObject();
                result.put((Object)"checkcodeImg", (Object)png_base64);
                return this.error(1, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!", result, null);
            }
            token = Security.getToken((String)user.getId());
            Cookie cookie = new Cookie("designerToken", token);
            cookie.setPath("/");
            this.response.addCookie(cookie);
            if (originUser != null) {
                originUser.setPwdErrorTimes(0);
                superProcess.doUpdate(originUser);
            }
            JSONObject result = new JSONObject();
            result.put((Object)"designerToken", (Object)token);
            return this.success("ok", result);
        }
        catch (Exception e) {
            if (originUser != null) {
                originUser.setPwdErrorTimes(++count);
                if (count > 10) {
                    originUser.setStatus(0);
                }
                try {
                    superProcess.doUpdate(originUser);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            JSONObject result = new JSONObject();
            result.put((Object)"checkcodeImg", (Object)png_base64);
            return this.error(1, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef!", result, null);
        }
    }

    @PostMapping(value={"/logout"})
    @ApiOperation(value="\u6ce8\u9500\u767b\u9646", notes="\u6ce8\u9500\u767b\u9646")
    public Resource logout() {
        try {
            String designerId = Security.getDesignerIdFromToken((HttpServletRequest)this.request);
            Cookie cookie = new Cookie("designerToken", "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            this.response.addCookie(cookie);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    public String getCheckCodeImg() throws Exception {
        this.response.setContentType("image/jpg");
        this.response.setHeader("Pragma", "No-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        BufferedImage image = new BufferedImage(WIDTH + 6, HEIGHT + 4, 1);
        Graphics g = image.getGraphics();
        char[] rands = this.generateCheckCode();
        this.drawBackground(g);
        this.drawRands(g, rands);
        g.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPG", baos);
        byte[] bytes = baos.toByteArray();
        String png_base64 = Base64Util.encode((byte[])bytes);
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        this.request.getSession().setAttribute(this.CheckCode_Session, (Object)String.valueOf(rands));
        return png_base64;
    }

    private void drawBackground(Graphics gd) {
        Random r = new Random();
        gd.setColor(Color.black);
        gd.clipRect(0, 0, WIDTH + 6, HEIGHT + 4);
        gd.setColor(Color.white);
        gd.fillRect(1, 1, WIDTH + 4, HEIGHT + 2);
        for (int i = 0; i < 30; ++i) {
            int x = r.nextInt(WIDTH) + 2;
            int y = r.nextInt(HEIGHT) + 3;
            int xl = r.nextInt(12);
            int yl = r.nextInt(12);
            int red = r.nextInt(255);
            int green = r.nextInt(255);
            int blue = r.nextInt(255);
            gd.setColor(new Color(red, green, blue));
            gd.drawLine(x, y, x + xl, y + yl);
        }
    }

    private void drawRands(Graphics g, char[] rands) {
        g.setColor(new Color(0x1F1F1F));
        Font font = new Font("Fixedsys", 0, HEIGHT);
        g.setFont(font);
        int xx = WIDTH / (rands.length + 1);
        int codeY = HEIGHT;
        for (int i = 0; i < rands.length; ++i) {
            g.drawString("" + rands[i], (i + 1) * xx, codeY);
        }
    }

    private char[] generateCheckCode() {
        String chars = "0123456789abcdefghijkLmnopqrstuvwxyz";
        char[] rands = new char[4];
        for (int i = 0; i < 4; ++i) {
            int rand = new Random().nextInt(36);
            rands[i] = chars.charAt(rand);
        }
        return rands;
    }
}

