/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.link.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.link.LinkVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.link.service.LinkDesignTimeService;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u89c6\u56fe\u94fe\u63a5\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class LinkController
extends AbstractDesignTimeController {
    private LinkDesignTimeService linkDesignTimeService = DesignTimeServiceManager.linkDesignTimeService();

    @GetMapping(path={"/{applicationId}/links"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u72b6\u6001\u5217\u8868", notes="\u83b7\u53d6\u6807\u7b7e\u72b6\u6001\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="name", value="\u67e5\u8be2\u540d\u79f0", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=true, paramType="query", dataType="string")})
    public Resource getLinkList(@PathVariable String applicationId, String name, String type, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.linkDesignTimeService.queryByNameAndType(applicationId, name, type, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/links/{linkId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u94fe\u63a5\u8be6\u60c5", notes="\u83b7\u53d6\u94fe\u63a5\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="linkId", value="\u94fe\u63a5id", required=true, paramType="path", dataType="string")})
    public Resource doGetLink(@PathVariable String linkId) {
        try {
            LinkVO linkVO = (LinkVO)this.linkDesignTimeService.findById(linkId);
            return this.success("ok", linkVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/links"})
    @ApiOperation(value="\u65b0\u5efa\u94fe\u63a5", notes="\u65b0\u5efa\u94fe\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateLink(@PathVariable String applicationId, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            LinkVO linkVO = (LinkVO)this.json2obj(json, LinkVO.class);
            linkVO.setApplicationid(applicationId);
            linkVO.setParentId(applicationId);
            if (StringUtil.isBlank((String)linkVO.getId())) {
                linkVO.setId(Sequence.getDesignTimeSequence());
            }
            if (StringUtil.isBlank((String)linkVO.getName())) {
                return this.error(500, "{*[cn.myapps.km.category.name_not_null]*}", null);
            }
            DataPackage data = this.linkDesignTimeService.queryByNameAndType(applicationId, "", "", 1, 10);
            for (LinkVO vo : data.getDatas()) {
                if (!linkVO.getName().equals(vo.getName())) continue;
                return this.error(500, "{*[core.form.exist]*}", null);
            }
            this.linkDesignTimeService.save((Object)linkVO);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)linkVO.getId());
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/links"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u94fe\u63a5", notes="\u66f4\u65b0\u94fe\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateLink(@RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            LinkVO linkVO = (LinkVO)this.json2obj(json, LinkVO.class);
            this.linkDesignTimeService.saveOrUpdate((Object)linkVO);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/links"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u94fe\u63a5", notes="\u5220\u9664\u94fe\u63a5\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteLinks(@RequestBody String[] ids) {
        try {
            this.linkDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

