/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.eip.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.eip.EipVO;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.eip.service.EipDesignTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"eip\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class EipController
extends AbstractDesignTimeController {
    private EipDesignTimeService eipDesignTimeService = DesignTimeServiceManager.eipDesignTimeService();

    @GetMapping(path={"/{applicationId}/eips"})
    @ApiOperation(value="\u83b7\u53d6\u51fd\u6570\u5e93\u5217\u8868", notes="\u83b7\u53d6\u51fd\u6570\u5e93\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u9875\u6761\u6570", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=true, paramType="path", dataType="string")})
    public Resource getEipsList(@PathVariable String applicationId, String name, String pageNo, String linesPerPage) {
        int page = pageNo != null && pageNo.length() > 0 ? Integer.parseInt(pageNo) : 1;
        int line = linesPerPage != null && linesPerPage.length() > 0 ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage data = this.eipDesignTimeService.query(applicationId, name, page, line);
            return this.success("ok", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/{applicationId}/eips/{eipId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6eip\u8be6\u60c5", notes="\u83b7\u53d6eip\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="eipId", value="eipid", required=true, paramType="path", dataType="string")})
    public Resource doGetEip(@PathVariable String applicationId, @PathVariable String eipId) throws Exception {
        try {
            EipVO eipVO = (EipVO)this.eipDesignTimeService.findById(eipId);
            return this.success("ok", eipVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/eips"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efaeip", notes="\u65b0\u5efaeip")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateEips(@PathVariable String applicationId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            EipVO eipVO = (EipVO)this.json2obj(json, EipVO.class);
            eipVO.setApplicationid(applicationId);
            eipVO.setParentId(applicationId);
            this.doSaveValidate(eipVO);
            this.eipDesignTimeService.saveOrUpdate((Object)eipVO);
            JSONObject eipJson = new JSONObject();
            eipJson.put((Object)"id", (Object)eipVO.getId());
            return this.success("ok", eipJson);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/{applicationId}/eips/{eipId}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u66f4\u65b0eip", notes="\u66f4\u65b0eip")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateEips(@PathVariable String applicationId, @PathVariable String eipId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            EipVO rv = (EipVO)this.json2obj(json, EipVO.class);
            EipVO eipVO = (EipVO)this.eipDesignTimeService.findById(eipId);
            EipVO eip = (EipVO)BeanUtils.cloneBean((Object)eipVO);
            eip.setApplicationid(applicationId);
            eip.setXml(rv.getXml());
            eip.setName(rv.getName());
            eip.setDescription(rv.getDescription());
            this.doSaveValidate(eip);
            this.eipDesignTimeService.saveOrUpdate((Object)eip);
            return this.success("ok", null);
        }
        catch (OBPMValidateException ex) {
            ex.printStackTrace();
            return this.error(40001, ex.getValidateMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/eips"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664eip", notes="\u5220\u9664eip\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteEips(@RequestBody String[] ids) throws Exception {
        try {
            this.eipDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    private void doSaveValidate(EipVO eipVO) throws Exception {
        List list = this.eipDesignTimeService.list(eipVO.getParentId(), eipVO.getName());
        if (StringUtils.isBlank((String)eipVO.getId())) {
            for (EipVO r : list) {
                if (!r.getName().equals(eipVO.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        } else {
            for (EipVO r : list) {
                if (r.getId().equals(eipVO.getId()) || !r.getName().equals(eipVO.getName())) continue;
                throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        for (EipVO r : list) {
            if (!r.getName().equals(eipVO.getName()) || r.getId().equals(eipVO.getId())) continue;
            throw new OBPMValidateException("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }
}

