/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.common.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.controller.ErrorMessage;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import com.jayway.jsonpath.PathNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestController
public abstract class AbstractDesignTimeController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    protected HttpSession session;

    protected WebUser getUser() throws Exception {
        SuperUserDesignTimeService sprocess = DesignTimeServiceManager.superUserDesignTimeService();
        String userId = Security.getDesignerIdFromToken((HttpServletRequest)this.request);
        WebUser webUser = null;
        try {
            webUser = sprocess.getWebUserInstance(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return webUser;
    }

    public ParamsTable getParams() {
        ParamsTable pm = ParamsTable.convertHTTP((HttpServletRequest)this.request);
        if (pm.getParameter("_pagelines") == null) {
            pm.setParameter("_pagelines", (Object)"10");
        }
        return pm;
    }

    protected Resource success(String errmsg, Object data) {
        return new Resource(0, errmsg, data, null);
    }

    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, null, errors);
    }

    protected Resource error(int errcode, String errmsg, Object data, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, data, errors);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
        return this.error(40035, "\u4e0d\u5408\u6cd5\u7684\u53c2\u6570", null);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource requestbodyError(PathNotFoundException e) {
        e.printStackTrace();
        return this.error(406, "\u8bf7\u6c42\u5305\u4f53\u53c2\u6570\u51fa\u9519", null);
    }

    public Object json2obj(JSONObject json, Class c) throws Exception {
        Object o = c.newInstance();
        Map<String, Class<?>> fieldsMap = AbstractDesignTimeController.getObjectToMap(o);
        for (Map.Entry<String, Class<?>> next : fieldsMap.entrySet()) {
            Method method;
            Object value = json.get(next.getKey());
            boolean flag = false;
            if (value instanceof Integer) {
                flag = true;
                value = (int)((Integer)value);
            } else if (value instanceof String) {
                flag = value != null;
                value = (String)value;
            } else if (value instanceof Boolean) {
                flag = true;
                value = (Boolean)value;
            }
            if (next.getValue().toString().equals("class java.util.Date") && value != null && !StringUtil.isBlank((String)value.toString())) {
                String formatStr = String.valueOf(value).contains("T") ? "yyyy-MM-dd'T'HH:mm:ss" : "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat format = new SimpleDateFormat(formatStr);
                value = format.parse(String.valueOf(value));
            }
            if (!flag || (method = c.getMethod("set" + next.getKey().substring(0, 1).toUpperCase() + next.getKey().substring(1), next.getValue())) == null) continue;
            try {
                method.invoke(o, value);
            }
            catch (Exception ex) {
                if (method.getParameterTypes().length != 1) {
                    throw ex;
                }
                if (!Timestamp.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                ex.printStackTrace();
            }
        }
        return o;
    }

    public static Map<String, Class<?>> getObjectToMap(Object t) throws IllegalAccessException {
        HashMap param = new HashMap();
        for (Class<?> className = t.getClass(); className != Object.class; className = className.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = className.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                param.put(field.getName(), type);
            }
        }
        return param;
    }
}

