/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.chart.controller;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.chart.Chart;
import cn.myapps.designtime.chart.service.ChartDesignTimeService;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u7edf\u8ba1\u56fe\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/designtime/applications"}, produces={"application/json;charset=UTF-8"})
public class ChartController
extends AbstractDesignTimeController {
    private ChartDesignTimeService chartDesignTimeService = DesignTimeServiceManager.chartDesignTimeService();

    @GetMapping(path={"/modules/{moduleId}/charts"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u5217\u8868", notes="\u83b7\u53d6\u7edf\u8ba1\u56fe\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="currpage", value="\u9875\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="pagelines", value="\u9875\u6761\u6570", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="searchword", value="\u540d\u5b57", required=true, paramType="query", dataType="string")})
    public Resource getChartsList(@PathVariable String moduleId, String searchword) {
        ParamsTable params = this.getParams();
        String currpage = params.getParameterAsString("currpage");
        String pagelines = params.getParameterAsString("pagelines");
        int page = currpage != null && currpage.length() > 0 ? Integer.parseInt(currpage) : 1;
        int line = pagelines != null && pagelines.length() > 0 ? Integer.parseInt(pagelines) : 10;
        try {
            DataPackage data = this.chartDesignTimeService.queryByNameOrDescript(moduleId, searchword, page, line);
            JSONObject result = new JSONObject();
            JSONArray array = new JSONArray();
            for (Chart chart : data.getDatas()) {
                JSONObject rvJson = new JSONObject();
                rvJson.put((Object)"id", (Object)chart.getId());
                rvJson.put((Object)"name", (Object)chart.getName());
                rvJson.put((Object)"note", (Object)chart.getDescription());
                array.add((Object)rvJson);
            }
            result.put((Object)"linesPerPage", (Object)data.getLinesPerPage());
            result.put((Object)"pageCount", (Object)data.getPageCount());
            result.put((Object)"pageNo", (Object)data.getPageNo());
            result.put((Object)"rowCount", (Object)data.getRowCount());
            result.put((Object)"data", (Object)array);
            return this.success("ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(path={"/charts/{chartId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u8be6\u60c5", notes="\u83b7\u53d6\u7edf\u8ba1\u56fe\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="chartId", value="\u7edf\u8ba1\u56feid", required=true, paramType="path", dataType="string")})
    public Resource doGetChart(@PathVariable String chartId) throws Exception {
        try {
            Chart chart = (Chart)this.chartDesignTimeService.findById(chartId);
            return this.success("ok", chart);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PostMapping(path={"/{applicationId}/modules/{moduleId}/charts"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u5efa\u7edf\u8ba1\u56fe", notes="\u65b0\u5efa\u7edf\u8ba1\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doCreateCharts(@PathVariable String applicationId, @PathVariable String moduleId, @RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Chart chart = (Chart)this.json2obj(json, Chart.class);
            chart.setApplicationid(applicationId);
            chart.setParentId(moduleId);
            if (StringUtil.isBlank((String)chart.getId())) {
                chart.setId(Sequence.getDesignTimeSequence());
            }
            this.chartDesignTimeService.save((Object)chart);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)chart.getId());
            return this.success("ok", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @PutMapping(path={"/charts"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u7edf\u8ba1\u56fe", notes="\u66f4\u65b0\u7edf\u8ba1\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="chartId", value="\u7edf\u8ba1\u56feid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doUpdateCharts(@RequestBody String content) throws Exception {
        try {
            JSONObject json = JSONObject.fromObject((Object)content);
            Chart chart = (Chart)this.json2obj(json, Chart.class);
            this.chartDesignTimeService.saveOrUpdate((Object)chart);
            return this.success("ok", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }

    @DeleteMapping(path={"/charts"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u7edf\u8ba1\u56fe", notes="\u5220\u9664\u7edf\u8ba1\u56fe\uff08\u53ef\u6279\u91cf\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doDeleteCharts(@RequestBody String[] ids) throws Exception {
        try {
            this.chartDesignTimeService.delete(ids);
            return this.success("ok", "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(500, e.getMessage(), null);
        }
    }
}

