/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.conf;

import cn.myapps.base.web.interceptor.ActionInterceptor;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.NoopDistributedCacheProviderImpl;
import cn.myapps.designtime.common.filter.MultiLanguageFilter;
import cn.myapps.designtime.common.filter.TimeOutFilter;
import cn.myapps.designtime.upload.servlet.UploadServlet;
import cn.myapps.listener.ApplicationContextEventListener;
import cn.myapps.util.CheckCodeServlet;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import net.fckeditor.connector.ConnectorServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class MyappsMvcConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    public SpringApplicationContextUtil utils;

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/admin");
        registry.setOrder(Integer.MIN_VALUE);
        super.addViewControllers(registry);
    }

    @Bean
    public CommonsMultipartResolver multipartResolver() {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        multipartResolver.setMaxUploadSize(-1L);
        return multipartResolver;
    }

    @Bean
    public ApplicationContextEventListener applicationStartListener() {
        return new ApplicationContextEventListener();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"}).addResourceLocations(new String[]{"/"});
        String uploadsFolderPath = PropertyUtil.getPath() + "/uploads/";
        registry.addResourceHandler(new String[]{"/uploads/**"}).addResourceLocations(new String[]{"file:" + uploadsFolderPath});
        super.addResourceHandlers(registry);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        super.addInterceptors(registry);
        registry.addInterceptor((HandlerInterceptor)new ActionInterceptor()).addPathPatterns(new String[]{"/**/*.action"}).excludePathPatterns(new String[]{"/static/**"});
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean2() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new MultiLanguageFilter());
        bean.addUrlPatterns(new String[]{"/dwr/*", "/api/designtime/applications/*", "/api/designtime/login"});
        return bean;
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean3() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new TimeOutFilter());
        bean.addUrlPatterns(new String[]{"/*"});
        return bean;
    }

    @Bean
    public ServletRegistrationBean getCheckCodeServletRegistrationBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new CheckCodeServlet(), new String[0]);
        bean.addUrlMappings(new String[]{"/api/checkCodeImg"});
        return bean;
    }

    @Bean
    public ServletRegistrationBean getServletRegistrationBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new UploadServlet(), new String[0]);
        bean.addUrlMappings(new String[]{"/api/UploadServlet"});
        return bean;
    }

    @Bean
    public ServletRegistrationBean getConnectorServletRegistrationBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new ConnectorServlet(), new String[0]);
        bean.addUrlMappings(new String[]{"/formHtml/webeditor/editor/filemanager/connectors/*"});
        return bean;
    }

    @Bean
    public DistributedCacheProvider distributedCacheProvider() {
        return new NoopDistributedCacheProviderImpl();
    }
}

