/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.conf;

import cn.myapps.common.DataSourceFactory;
import cn.myapps.common.util.DbUtil;
import cn.myapps.components.MessageProvider;
import cn.myapps.components.SettingProvider;
import cn.myapps.components.requests.CreateMessageRequest;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import java.util.Collection;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@ConditionalOnProperty(value={"${spring.datasource}"})
@Configuration
public class DataSourceConfig
implements TransactionManagementConfigurer {
    @Value(value="${spring.datasource.url}")
    private String dbUrl;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.validationQuery}")
    private String validationQuery;

    @Bean
    public DataSource druidDataSource() {
        DataSource ds = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("driverClassName", this.driverClassName);
        properties.put("url", this.dbUrl);
        properties.put("username", this.username);
        properties.put("password", this.password);
        this.validationQuery = DbUtil.getValidationQuery((String)this.driverClassName);
        properties.put("validationQuery", this.validationQuery);
        try {
            ds = DataSourceFactory.create(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    @Bean
    public JdbcTemplate jdbcTemplate(DataSource kmDataSource) {
        return new JdbcTemplate(kmDataSource);
    }

    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(this.druidDataSource());
    }

    @Bean
    public MessageProvider messageProvider() {
        return new MessageProvider(){

            public void dispatch(String senderId, MessageType messageType, String title, String content, ReceiverType receiverType, String receiver, String businessNumber, String uniqueId) {
            }

            public void dispatch(CreateMessageRequest request) {
            }

            public void dispatch(Collection<CreateMessageRequest> requests) {
            }
        };
    }

    @Bean
    public SettingProvider settingProvider() {
        return new SettingProvider(){

            public String getSettingWithCache(String category, String key, int seconds) {
                return null;
            }

            public String getSetting(String category, String key) {
                return null;
            }
        };
    }
}

