/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.components;

import cn.myapps.components.events.DistributeDesignCacheObject;
import cn.myapps.components.events.ObjectEvent;
import cn.myapps.designtime.requests.RefreshDesignRequest;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.CompleteFurtherUtils;
import com.lmax.disruptor.EventHandler;
import java.util.Collection;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class ProcessingEventHandler
implements EventHandler<ObjectEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessingEventHandler.class);
    private final DiscoveryClient discoveryClient;
    private final JsonProvider jsonProvider;

    public ProcessingEventHandler(DiscoveryClient discoveryClient, JsonProvider jsonProvider) {
        this.discoveryClient = discoveryClient;
        this.jsonProvider = jsonProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ObjectEvent event, long l, boolean b) throws Exception {
        List runtimeInstances = this.discoveryClient.getInstances("obpm-runtime");
        DistributeDesignCacheObject cacheEvent = (DistributeDesignCacheObject)event.getData();
        try {
            if (!CollectionUtils.isEmpty((Collection)runtimeInstances)) {
                String finalAppId = cacheEvent.getAppId();
                CompleteFurtherUtils.execute((Collection)runtimeInstances, instance -> this.doRefreshRequest((ServiceInstance)instance, finalAppId, cacheEvent.getData()));
            }
        }
        finally {
            logger.error("\u63a8\u9001\u6570\u636e\u5230obpm-runtime\u5b9e\u4f8b:{}-\u6570\u636e={}", (Object)runtimeInstances.size(), (Object)cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshRequest(ServiceInstance instance, String appId, RefreshDesignRequest rq) {
        String targetUrl = String.format("%s/obpm/api/runtime/applications/%s/components/do-refresh", instance.getUri(), appId);
        try (CloseableHttpClient httpClient = null;){
            httpClient = HttpClientBuilder.create().build();
            HttpPut put = new HttpPut(targetUrl);
            String json = this.jsonProvider.getJson((Object)rq);
            put.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            logger.error("\u63a8\u9001\u8868\u5355\u6570\u636e\u81f3{}-\u6570\u636e={} \u4fdd\u5b58\u7ed3\u679c\u4e3a:{}-{}", new Object[]{put.getURI(), json, response.getStatusLine(), result});
        }
        catch (Exception ex) {
            logger.error("\u5237\u65b0runtime({})\u7ec4\u4ef6\u7f13\u5b58\u53d1\u751f\u5f02\u5e38:{}", new Object[]{targetUrl, rq, ex});
        }
    }
}

