package com.teemlink.obpm_runtime;

import cn.myapps.base.AbstractControllerTests;
import cn.myapps.run.RuntimeWithConsulApp;
import com.teemlink.sync.model.ColumnValue;
import com.teemlink.sync.model.DataObject;
import com.teemlink.sync.model.DataOperation;
import com.teemlink.sync.service.SyncServiceImpl;
import net.sf.json.JSONObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class TestSync extends AbstractControllerTests {

    @Test
    public void testCreate() throws Exception{
        DataOperation dataPackage = new DataOperation();
        dataPackage.setAction(DataOperation.ACT_CREATE);
        dataPackage.setApplicationId("sOZu9kthmxyP8qQfq0e");
        dataPackage.setDataSourceName("接口测试");

        DataObject dataObject  = new DataObject();
        dataObject.setId("asdasdas");
        dataObject.setTableName("t_sync");

        ColumnValue columnValue = new ColumnValue();
        columnValue.setName("id");
        columnValue.setType(ColumnValue.TYPE_TEXT);
        columnValue.setValue("asdasdas");

        ColumnValue columnValue1 = new ColumnValue();
        columnValue1.setName("name");
        columnValue1.setValue("测试的哦");
        columnValue1.setType(ColumnValue.TYPE_TEXT);

        ColumnValue columnValue2 = new ColumnValue();
        columnValue2.setName("starttime");
        columnValue2.setValue("2021-04-08 14:50:54");
        columnValue2.setType(ColumnValue.TYPE_DATETIME);

        ColumnValue columnValue3 = new ColumnValue();
        columnValue3.setName("endtime");
        columnValue3.setValue("2021-04-08 14:50:54.111");
        columnValue3.setType(ColumnValue.TYPE_TIMESTAMP);

        ColumnValue columnValue4 = new ColumnValue();
        columnValue4.setName("age");
        columnValue4.setValue("111");
        columnValue4.setType(ColumnValue.TYPE_INTEGER);

        ColumnValue columnValue5 = new ColumnValue();
        columnValue5.setName("num");
        columnValue5.setValue("112221.22");
        columnValue5.setType(ColumnValue.TYPE_DOUBLE);

        ColumnValue columnValue6 = new ColumnValue();
        columnValue6.setName("date");
        columnValue6.setValue("2021-04-08");
        columnValue6.setType(ColumnValue.TYPE_DATE);

        List<ColumnValue> list = new ArrayList<ColumnValue>();
        list.add(columnValue);
        list.add(columnValue1);
        list.add(columnValue2);
        list.add(columnValue3);
        list.add(columnValue4);
        list.add(columnValue5);
        list.add(columnValue6);

        dataObject.setColumnValues(list);
        dataPackage.setDataObject(dataObject);

        SyncServiceImpl service = new SyncServiceImpl();
        service.syncData(dataPackage);
    }

    @Test
    public void testUpdate() throws Exception{
        DataOperation dataPackage = new DataOperation();
        dataPackage.setAction(DataOperation.ACT_UPDATE);
        dataPackage.setApplicationId("sOZu9kthmxyP8qQfq0e");
        dataPackage.setDataSourceName("接口测试");

        DataObject dataObject  = new DataObject();
        dataObject.setId("asdasdas");
        dataObject.setTableName("t_upload");

        ColumnValue columnValue1 = new ColumnValue();
        columnValue1.setName("name");
        columnValue1.setValue(""+(new Date()));

        List<ColumnValue> list = new ArrayList<ColumnValue>();
        list.add(columnValue1);

        dataObject.setColumnValues(list);
        dataPackage.setDataObject(dataObject);

        SyncServiceImpl service = new SyncServiceImpl();
        service.syncData(dataPackage);
    }

    @Test
    public void testDetele() throws Exception{
        DataOperation dataPackage = new DataOperation();
        dataPackage.setAction(DataOperation.ACT_DELETE);
        dataPackage.setApplicationId("sOZu9kthmxyP8qQfq0e");
        dataPackage.setDataSourceName("接口测试");

        DataObject dataObject  = new DataObject();
        dataObject.setId("asdasdas");
        dataObject.setTableName("t_upload");

        dataPackage.setDataObject(dataObject);

        SyncServiceImpl service = new SyncServiceImpl();
        service.syncData(dataPackage);
    }

    @Test
    public void testController() throws Exception{
        DataOperation dataPackage = new DataOperation();
        dataPackage.setAction(DataOperation.ACT_CREATE);
        dataPackage.setApplicationId("sOZu9kthmxyP8qQfq0e");
        dataPackage.setDataSourceName("接口测试");

        DataObject dataObject  = new DataObject();
        dataObject.setId("asdasdas");
        dataObject.setTableName("t_sync");

        ColumnValue columnValue = new ColumnValue();
        columnValue.setName("id");
        columnValue.setType(ColumnValue.TYPE_TEXT);
        columnValue.setValue("asdasdas");

        ColumnValue columnValue1 = new ColumnValue();
        columnValue1.setName("name");
        columnValue1.setValue("测试的哦");
        columnValue1.setType(ColumnValue.TYPE_TEXT);

        ColumnValue columnValue2 = new ColumnValue();
        columnValue2.setName("starttime");
        columnValue2.setValue("2021-04-08 14:50:54");
        columnValue2.setType(ColumnValue.TYPE_DATETIME);

        ColumnValue columnValue3 = new ColumnValue();
        columnValue3.setName("endtime");
        columnValue3.setValue("2021-04-08 14:50:54.111");
        columnValue3.setType(ColumnValue.TYPE_TIMESTAMP);

        ColumnValue columnValue4 = new ColumnValue();
        columnValue4.setName("age");
        columnValue4.setValue("111");
        columnValue4.setType(ColumnValue.TYPE_INTEGER);

        ColumnValue columnValue5 = new ColumnValue();
        columnValue5.setName("num");
        columnValue5.setValue("112221.22");
        columnValue5.setType(ColumnValue.TYPE_DOUBLE);

        ColumnValue columnValue6 = new ColumnValue();
        columnValue6.setName("date");
        columnValue6.setValue("2021-04-08");
        columnValue6.setType(ColumnValue.TYPE_DATE);

        List<ColumnValue> list = new ArrayList<ColumnValue>();
        list.add(columnValue);
        list.add(columnValue1);
        list.add(columnValue2);
        list.add(columnValue3);
        list.add(columnValue4);
        list.add(columnValue5);
        list.add(columnValue6);

        dataObject.setColumnValues(list);
        dataPackage.setDataObject(dataObject);

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/runtime/sync");
        requestBuilder.content(JSONObject.fromObject(dataPackage).toString());
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

}
