package cn.myapps.support.lanxin.service;

import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.support.lanxin.util.LanxinConfig;
import cn.myapps.support.lanxin.util.LanxinSecretCache;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class LxOrgServiceTest {

	
	String access_token;
	DomainVO domain ;
    @Before
	public void init(){
		
		String domainId = LanxinConfig.getDomainId();
		DomainProcess domainProcess;
		try {
			domainProcess = AuthTimeServiceManager.domainRuntimeService();
		    domain = (DomainVO) domainProcess.doView(domainId);
			access_token = LxApiService.getAccessToken(LanxinSecretCache.get(domainId));
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
}
