package cn.myapps.support.lanxin.service;

import java.util.Date;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.support.lanxin.service.impl.LanxinMessageService;
import cn.myapps.support.lanxin.util.LanxinConfig;
import cn.myapps.support.lanxin.util.LanxinSecretCache;
import junit.framework.Assert;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class LxMessageServiceTest {

	String access_token;
	DomainVO domain ;
	/*@Before*/
	public void init(){
		
		String domainId = LanxinConfig.getDomainId();
		DomainProcess domainProcess;
		try {
			domainProcess = AuthTimeServiceManager.domainRuntimeService();
		    domain = (DomainVO) domainProcess.doView(domainId);
			access_token = LxApiService.getAccessToken(LanxinSecretCache.get(domainId));
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	/**
	 * 流程引擎：发送消息
	 * @throws Exception
	 */
	@Test
	public void sendCardMessage() throws Exception {
		String title = "已送出";
		String description = "你提交的报销费用申请单已经通过上级部门主管审核";
		String flowTypeMessage = "提交";
		String touser = "18200770818";
		Document doc = new Document();
		String id = "1";
		String domainid = LanxinConfig.getDomainId();
		String applicationid = "1";
		String flowid = "1";
		doc.setDomainid(domainid);
		doc.setApplicationid(applicationid);
		doc.setLastmodified(new Date());
		doc.setId(id);
		
		WebUser webUser = new WebUser();
		webUser.setName("Seven");
		LanxinMessageService.send(title,description,touser,doc,webUser );
	}
	
	
	/**
	 * Iscript脚本：发送消息
	 */
	@Test
	public void sendMessage() throws Exception {
		String touser = "xzzy02";
		String content = "测试content" ;
		String domainId = "11e1-81e2-37f74759-9124-47aada6b7467" ;
		String applicationid = null;
		String title = "测试title";
		String description = "测试description";
		String url = "www.baidu.com";
		String picUrl = "http://uniform07-open.e.lanxin.cn/opendata/1704/d7a249076a5a46ffba2e7ba6662bc06b_monkey.jpg";
		boolean sendRichTextMessage = LanxinMessageService.sendRichTextMessage(touser, title, description, url, picUrl, domainId, applicationid);
		
		Assert.assertEquals(true, sendRichTextMessage);
		
		boolean sendTextMessage = LanxinMessageService.sendTextMessage(touser, content, domainId, applicationid);
		
		Assert.assertEquals(true, sendTextMessage);
		

	}
}
