package cn.myapps.support.lanxin.service;

import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.support.lanxin.model.Department;
import cn.myapps.support.lanxin.service.api.impl.ContactService;
import cn.myapps.support.lanxin.util.LanxinConfig;
import cn.myapps.support.lanxin.util.LanxinSecretCache;
import net.sf.json.JSONObject;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class LxApiServiceTest {

	String access_token;
	DomainVO domain ;
	@Before
	public void init(){
		
		String domainId = LanxinConfig.getDomainId();
		DomainProcess domainProcess;
		try {
			domainProcess = AuthTimeServiceManager.domainRuntimeService();
		    domain = (DomainVO) domainProcess.doView(domainId);
			access_token = LxApiService.getAccessToken(LanxinSecretCache.get(domainId));
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	/**
	 * 同步至蓝信
	 */
	@Test
	public void synch2WeixinTest(){
		try {
			JSONObject synch2Weixin = LanxinService.synch2Lanxin(domain);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * 同步至本地客户端
	 */
	@Test
	public void synchFromWeixinTest(){
		try {
			JSONObject synchFromWeixin = LanxinService.synchFromLanxin(domain);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/**
	 * 获取部门列表
	 */
	@Test
	public void getDepartmentListTest() {
		List<Department> departmentList = ContactService.getDepartmentList(access_token);
		
		for(Department dept : departmentList){
			//System.out.println(dept.toString());
		}
	}
}
