package cn.myapps.runtime.workflow.controller;

import static com.jayway.jsonpath.JsonPath.parse;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.ArrayList;
import java.util.Map;

import javax.servlet.http.Cookie;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Option;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.util.sequence.Sequence;

/**
 *
 * Workflow Restful 测试类
 * 
 * @author ahan
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class WorkflowControllerTest extends AbstractControllerTests {

	 Cookie cookie;
	 //自由流程的docId
	 String docId;
	@Before
	public void initUser() throws Exception {
		docId = Sequence.getSequence()+"--__xTeazT2hYRCoxwLzEpn";
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}
	/**
	 * 测试 GET /api/runtime/{applicationId}/workflows/{instanceId}/states 接口<br/>
	 * 获取文档的流程状态<br/>
	 * 返回文档的流程状态和处理人信息。
	 */
	@Test
	public void testQueryWorkflow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String instanceId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl-__6DqsGRLKbJo9ExeSjc5";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + application + "/workflows/" + instanceId + "/states");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

//	/**
//	 * 测试 GET /api/runtime/{applicationId}/workflows/{instanceId}/flow-historys
//	 * 接口<br/>
//	 * 获取文档的流程历史<br/>
//	 * 返回文档的流程历史信息（包含流程图url）。
//	 */
//	@Test
//	public void testGetHistorys() throws Exception {
//		String application = "Q11e7-5f98-d7d66840-917f-e799edecb417";
//		String instanceId = "Q11e7-76dd-cefc7139-aa03-c5c684d033ca";
//
//		// 构建请求 /documents/{docId}/workflows/flow-historys
//		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
//				"/api/runtime/" + application + "/documents/" + instanceId + "/workflows/flow-historys");
//		requestBuilder.cookie(cookie);
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//
//	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/workflows/{instanceId}/remind-historys
	 * 接口<br/>
	 * 获取文档的催办信息<br/>
	 */
	@Test
	public void testGetRemindHistorys() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String instanceid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl-__6DqsGRLKbJo9ExeSjc5";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + application + "/documents/" + instanceid + "/workflows/remind-historys");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 POST /api/runtime/{applicationId}/documents/{docid}/panels/initiate
	 * 接口<br/>
	 * 发起流程<br/>
	 */
	@Test
	public void testInitiate() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		String content = "{\"document\":{\"items\":{\"开始时间\":\"2019-07-12 00:00\",\"结束时间\":\"2019-07-18 00:00\",\"备注\":\"\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\"__GD2W0pmZaaNEdpqMIDL\",\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"docId\":\"PAHGu2zwlWne0K492rv\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\"__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl\"}";
		// 构建请求 /documents/{docid}/workflows/initiate
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/panels/initiate");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/workflows/{instanceId}/panels/submission
	 * 接口<br/>
	 * 获取提交面板<br/>
	 */
	@Test
	public void testSubmissionPanels() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docId = "__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl";
		String contentStr = "{\"document\":{\"items\":{\"备注\":\"wqqw\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\"__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl\",\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"docId\":\"__GD2W0pmZaaNEdpqMIDL\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\"__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl\"}";
		net.sf.json.JSONObject jsonObject = net.sf.json.JSONObject.fromObject(contentStr);

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + application + "/documents/" + docId + "/panels/submission").content(contentStr);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));

	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/documents/{docid}/panels/initiate 接口<br/>
	 * 已保存的文档，获取流程发起面板<br/>
	 */
	@Test
	public void testInitiatePanels() {
		try {
			String applicationId = "sOZu9kthmxyP8qQfq0e";
			String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
			String formid = "__r3Uat20oAOwkP9f8fCl";
			String content = "{\"document\":{\"items\":{\"备注\":\"\"},\"applicationId\":"+applicationId+",\"id\":"+docid+",\"formId\":"+formid+",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":"+formid+",\"docId\":"+docid+",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":"+applicationId+",\"id\":"+docid+"}";

			// 构建请求
			MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
					"/api/runtime/" + applicationId + "/documents/" + docid + "/panels/initiate");
			requestBuilder.content(content);
			requestBuilder.cookie(cookie);
			ResultActions resultActions = mockMvc.perform(requestBuilder);

			resultActions.andExpect(status().isOk());
			resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
			resultActions.andExpect(jsonPath("$.errcode").value(0));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/documents/{docid}/panels/initiate 接口<br/>
	 * 新建临时文档<br/>
	 */
	@Test
	public void testInitiatePanelsWithTempDocument() {
		try {
			String applicationId = "sOZu9kthmxyP8qQfq0e";
			String formId = "__r3Uat20oAOwkP9f8fCl";

			MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
					"/api/runtime/" + applicationId + "/forms/" + formId + "/empty");

			// 构建POST /api/runtime/{applicationId}/forms/{formid}/empty请求
			requestBuilder.cookie(cookie);
			ResultActions resultActions = mockMvc.perform(requestBuilder);

			resultActions.andExpect(status().isOk());
			resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
			resultActions.andExpect(jsonPath("$.errcode").value(0));
			resultActions.andExpect(jsonPath("$.data.istmp").value(true));
			resultActions.andExpect(jsonPath("$.data.formid").value(formId));
			resultActions.andExpect(jsonPath("$.data.id").isNotEmpty());

			// 获取返回的数据并解析
			String content = resultActions.andReturn().getResponse().getContentAsString();
			Configuration configuration = Configuration.defaultConfiguration();
			configuration = configuration.addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL);

			DocumentContext parse = parse(content, configuration);

		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}

	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/submit
	 * 接口<br/>
	 * 已保存的带有流程的文档，提交流程。<br/>
	 */
	@Test
	public void testSubmitWorkflow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = Sequence.getSequence()+"--9c0aqDXwpcfHP2G5wCv";

		String content = "{\"document\":{\"items\":{\"开始时间\":\"2020-04-01 00:00\",\"结束时间\":\"2020-04-03 00:00\",\"请假天数\":\"2\",\"备注\":\"1\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":"+docid+",\"templateForm\":\"\",\"formId\":\"9c0aqDXwpcfHP2G5wCv\",\"sign\":\"\",\"parentId\":\"\",\"isRelate\":\"undefined\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"9c0aqDXwpcfHP2G5wCv\",\"docId\":"+docid+",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":"+docid+",\"flowId\":\"fW1801qkQ6PsAcfxuI2\",\"currentNodeId\":\"1566350813656\",\"nextNodeIds\":[\"1566350840526\"],\"submitTo\":[],\"subFlowApprover\":[],\"attitude\":\"\"}";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/submit");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("提交成功"));

	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/submit
	 * 接口<br/>
	 * 新建的有流程提交按钮的文档为临时文档，提交流程。<br/>
	 * 此文档应该有瞬态的流程实例。<br/>
	 *
	 * 分为三个步骤<br/>
	 * <br/>
	 * <li>测试 GET /api/runtime/{applicationId}/forms/{formid}/empty 接口<br/>
	 * <li>测试 GET /api/runtime/{applicationId}/documents/{docid}/panels/submission
	 * 接口<br/>
	 *
	 * <br>
	 * 此为新建并提交流程的全部步骤，1、新建空文档并在服务器缓存此文档和创建瞬态流程；2、获取此文档的提交面板信息；3、提交流程。<br/>
	 */
	@Test
	public void testSubmitWorkflowWithTemp() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		// 带有流程处理的表单应该有瞬态的流程实例
		String formId = "__r3Uat20oAOwkP9f8fCl";

		// 1、新建空文档并在服务器缓存此文档和创建瞬态流程；
		MockHttpServletRequestBuilder request = buildGetRequest(
				"/api/runtime/" + applicationId + "/forms/" + formId + "/empty");

		request.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(request);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.data.istmp").value(true));

		String content = resultActions.andReturn().getResponse().getContentAsString();

		DocumentContext parse = parse(content);

		Map<String, Object> items = parse.read("$.data.items");

		String docId = parse.read("$.data.id");

		// 2、获取此文档的提交面板信息；
		request = buildPostRequest("/api/runtime/" + applicationId + "/documents/" + docId + "/panels/submission");
		request.cookie(cookie);
		String content2 = "{\"document\":{\"items\":{\"开始时间\":\"\",\"结束时间\":\"\",\"备注\":\"\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\""+docId+"\",\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"docId\":\""+docId+"\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":"+applicationId+",\"id\":\""+docId+"\"}";
		request.content(content2);
		resultActions = mockMvc.perform(request);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.data.flowId").isNotEmpty());
		resultActions.andExpect(jsonPath("$.data.currentNodeId").isNotEmpty());
		resultActions.andExpect(jsonPath("$.data.nextNodes[0].id").isNotEmpty());

		content = resultActions.andReturn().getResponse().getContentAsString();

		parse = parse(content);
		String flowId = parse.read("$.data.flowId");
		String currentNodeId = parse.read("$.data.currentNodeId");
		String nextNode = parse.read("$.data.nextNodes[0].id");
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/workflows/{instanceId}/panels/back
	 * 接口<br/>
	 * 获取流程回退面板<br/>
	 */
	@Test
	public void testBackPanels() throws Exception {

		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/panels/back");
		requestBuilder.cookie(cookie);
		String content2 = "{\"document\":{\"items\":{\"开始时间\":\"\",\"结束时间\":\"\",\"备注\":\"\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":\""+docid+"\",\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"sign\":\"\",\"parentId\":\"\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"docId\":\""+docid+"\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":"+application+",\"id\":\""+docid+"\"}";
		requestBuilder.content(content2);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
	}

//	/**
//	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/back 接口<br/>
//	 * 回退流程<br/>
//	 */
//	@Test
//	public void testBackWorkflow() throws Exception {
//		String application = "Q11e7-5f98-d7d66840-917f-e799edecb417";
//		String docid = "BJESCQGJUTqyqkL7TI6";
//
//		String content = "{\"document\":{\"items\":{\"开始时间\":\"2019-07-04 00:00\",\"结束时间\":\"2019-07-25 00:00\",\"备注\":\"21e12e\"},\"applicationId\":\"Q11e7-5f98-d7d66840-917f-e799edecb417\",\"id\":\"BJESCQGJUTqyqkL7TI6\",\"formId\":\"Qwgw8EmPgt7pl1vVHHdz\",\"sign\":\"\",\"parentId\":\"\",\"stateId\":\"Ot2wCBwQoOk40yANTCp\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"Qwgw8EmPgt7pl1vVHHdz\",\"docId\":\"BJESCQGJUTqyqkL7TI6\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"Q11e7-5f98-d7d66840-917f-e799edecb417\",\"id\":\"BJESCQGJUTqyqkL7TI6\",\"flowId\":\"Q5EWSM5Bm0UOk3cYj4T0\",\"currentNodeId\":\"1532945589954\",\"nextNodeIds\":[\"1532945544660\"],\"attitude\":\"iujnk\"}";
//		// 构建请求
//		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
//				"/api/runtime/" + application + "/documents/" + docid + "/workflows/back");
//		requestBuilder.cookie(cookie);
//		requestBuilder.content(content);
//
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//		resultActions.andExpect(jsonPath("$.data").value("回退成功"));
//	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/retracement
	 * 接口<br/>
	 * 撤回流程<br/>
	 */
	@Test
	public void testRetracementWorkflow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/retracement");

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("撤回成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/suspend 接口<br/>
	 * 挂起流程<br/>
	 */
	@Test
	public void testSuspendWorkflow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/suspend");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("挂起成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/recovery 接口<br/>
	 * 恢复流程<br/>
	 */
	@Test
	public void testRecoveryWorkflow() throws Exception {
		testSuspendWorkflow();
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/recovery");

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("恢复成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/remind 接口<br/>
	 * 催办流程<br/>
	 */
	@Test
	public void testReminderWorkflow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		String content = "{\"document\":{\"items\":{\"开始时间\":\"\",\"结束时间\":\"\",\"备注\":\"\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":"+docid+",\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"sign\":\"\",\"parentId\":\"\",\"stateId\":\"zMz9xN3GhIDSUMtlv45\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__r3Uat20oAOwkP9f8fCl\",\"docId\":"+docid+",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":"+docid+",\"nodertIds\":[\"U3b9dcFmuJC9vrjdXuh\"],\"attitude\":\"\"}";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/remind");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("催办成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/termination 接口<br/>
	 * 终止流程<br/>
	 */
	@Test
	public void testTerminateWorkflow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__uLVGsGZbEaRzkNoEgaI--__xTeazT2hYRCoxwLzEpn";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/termination");

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("终止成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/freeflows/submit 接口<br/>
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/freeflows/back 接口<br/>
	 * 提交和回退自由流程<br/>
	 */
	@Test
	public void testSubmitFreeFlows() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";

		//String content = "{\"document\":{\"items\":{\"开始时间\":\"2019-11-13 00:00\",\"结束时间\":\"2019-11-27 00:00\",\"备注\":\"qwer123\"},\"applicationId\":\"__6L7jV0BIHtm5CAMnelL\",\"id\":\""+docId+"\",\"formId\":\"QOGMmff1QTZYqFk5vfeD\",\"sign\":\"\",\"parentId\":\"\",\"isRelate\":\"undefined\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"QOGMmff1QTZYqFk5vfeD\",\"docId\":\""+docId+"\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"__6L7jV0BIHtm5CAMnelL\",\"id\":\""+docId+"\",\"nextUserId\":\"zPsp2hk7CEwtqeMCwtj\",\"attitude\":\"1\"}";
		String content = "{\"document\":{\"items\":{\"申请人\":\"\",\"备注\":\"345\"},\"applicationId\":"+application+",\"id\":\""+docId+"\",\"templateForm\":\"\",\"formId\":\"__xTeazT2hYRCoxwLzEpn\",\"sign\":\"\",\"parentId\":\"\",\"isRelate\":\"undefined\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__xTeazT2hYRCoxwLzEpn\",\"docId\":\""+docId+"\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":"+application+",\"id\":\""+docId+"\",\"nextUserId\":\"zPsp2hk7CEwtqeMCwtj\",\"attitude\":\"\"}";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docId + "/freeflows/submit");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("自由流程提交成功"));

//		String userid = "0TblO2uKjQ2sLDY64yF";
//		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		String token = Security.getToken(user.getId());
//		// 存放到cookie
//		cookie = new Cookie(Security.ACCESS_TOKEN, token);
////				cookie.setHttpOnly(true);//调试方便，先注释
//		cookie.setPath("/");
//		WebUser webUser =new WebUser(user);
//		WebUser.setWebUser(webUser,session);
//
//		requestBuilder = buildGetRequest(
//				"/api/runtime/" + application + "/forms/QOGMmff1QTZYqFk5vfeD/documents/"+ docid+"?appId="+application+"&docid="+docid+"&formId=QOGMmff1QTZYqFk5vfeD");
//
//		requestBuilder.cookie(cookie);
//		resultActions = mockMvc.perform(requestBuilder);
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//
//		String result = resultActions.andReturn().getResponse().getContentAsString();
//
//		DocumentContext parse = parse(result);
//
//		String stateId = parse.read("$.data.stateId");
//
//		String content2 = "{\"document\":{\"items\":{\"开始时间\":\"2019-11-13 00:00\",\"结束时间\":\"2019-11-27 00:00\",\"备注\":\"1212321\"},\"applicationId\":\"Q11e7-5f98-d7d66840-917f-e799edecb417\",\"id\":\""+docid+"\",\"formId\":\"QOGMmff1QTZYqFk5vfeD\",\"sign\":\"\",\"parentId\":\"\",\"stateId\":\""+stateId+"\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"QOGMmff1QTZYqFk5vfeD\",\"docId\":\""+docid+"\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"Q11e7-5f98-d7d66840-917f-e799edecb417\",\"id\":\""+docid+"\",\"nextUserId\":\"zPsp2hk7CEwtqeMCwtj\",\"attitude\":\"\"};";
//		// 构建请求
//		requestBuilder = buildPutRequest(
//				"/api/runtime/" + application + "/documents/" + docid + "/freeflows/back");
//		requestBuilder.cookie(cookie);
//		requestBuilder.content(content2);
//
//		resultActions = mockMvc.perform(requestBuilder);
//
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//		resultActions.andExpect(jsonPath("$.data").value("自由流程回退成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/freeflows/complete 接口<br/>
	 * 结束自由流程<br/>
	 */
	@Test
	public void testCompleteFreeFlows() throws Exception {
		testSubmitFreeFlows();
		String application = "sOZu9kthmxyP8qQfq0e";
		//String content = "{\"document\":{\"items\":{\"开始时间\":\"2019-07-09 15:26\",\"结束时间\":\"2019-07-09 15:26\",\"备注\":\"1212\"},\"applicationId\":\"__6L7jV0BIHtm5CAMnelL\",\"id\":\""+docId+"\",\"formId\":\"OGMmff1QTZYqFk5vfeD\",\"sign\":\"\",\"parentId\":\"\",\"stateId\":\"icz4zIrOksd4n8A1JAm\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"OGMmff1QTZYqFk5vfeD\",\"docId\":\""+docId+"\",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"__6L7jV0BIHtm5CAMnelL\",\"id\":\""+docId+"\",\"attitude\":\"\"}";
		String content ="{\"document\":{\"items\":{\"申请人\":\"\",\"备注\":\"345\"},\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":"+docId+",\"templateForm\":\"\",\"formId\":\"__xTeazT2hYRCoxwLzEpn\",\"sign\":\"\",\"parentId\":\"\",\"stateId\":\"__o5fymJ0UbNGoWUEWhe5--__xTeazT2hYRCoxwLzEpn-__6PxHy2PvXHrqjP1vOF9\",\"subDocuments\":[],\"versions\":\"0\"},\"formId\":\"__xTeazT2hYRCoxwLzEpn\",\"docId\":"+docId+",\"parentId\":\"\",\"templateForm\":\"\",\"viewId\":\"\",\"applicationId\":\"sOZu9kthmxyP8qQfq0e\",\"id\":"+docId+",\"attitude\":\"\"}";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docId + "/freeflows/complete");
		requestBuilder.content(content);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("自由流程结束成功"));
	}

	/**
	 * 测试 PUT /api/runtime/{applicationId}/documents/{docid}/workflows/approvers 接口<br/>
	 * 更新流程节点审批人<br/>
	 */
	@Test
	public void testUpdateApprovers() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl";

		JSONObject content = new JSONObject();
		java.util.List<String> auditorList = new ArrayList<>();
		auditorList.add("zPsp2hk7CEwtqeMCwtj");
		content.put("auditorList",auditorList);


		//String content1 = "{\"auditorList\":\"[0TblO2uKjQ2sLDY64yF]\"}";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/approvers");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content.toJSONString());
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("修改成功"));
	}

	@Test
	public void testaddAuditor() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__u51LF0YaaqKmuccrudN--__r3Uat20oAOwkP9f8fCl";
		String content ="[\"zPsp2hk7CEwtqeMCwtj\"]";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/approver/addition");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("主办加签成功"));
	}

	@Test
	public void testaddCoAuditor() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String content = "[\"zPsp2hk7CEwtqeMCwtj\"]";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/assist/addition");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value("协办加签成功"));
	}

	@Test
	public void testdoSelectByFlow() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String flowid = "__qy2QvZYl8cSTsoJjS2c";
		String nodeid = "1532945589954";
		String type = "3";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + application + "/documents/" + docid + "/workflows/"+flowid+"/selectApprovers?nodeId="+nodeid+"&type="+type);

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	@Test
	public void testdoFlowSupplement() throws Exception {
		String application = "sOZu9kthmxyP8qQfq0e";
		String instanceId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl-__4bHV8DlUHKgr7AL8Ipr";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/" + application + "/workflows/"+instanceId+"/supplement?comments=1");

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

}
