package cn.myapps.runtime.widget.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.constans.Web;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * Created by Seven on 2017/11/4.
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class PageWidgetControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        String userid = "zPsp2hk7CEwtqeMCwtj";
        UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
        String token = Security.getToken(userid);
        // 存放到cookie
        cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
//		response.addCookie(cookie);
    }

    /**
     * 测试  GET /api/runtime/{applicationId}/widgets/{widgetId} 接口<br/>
     * 获取指定widget内容
     * @throws Exception
     */
    @Test
    public void doDisplayWidget() throws Exception {

        //String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";

        Collection<String> widgetIds = new ArrayList<String>();
        widgetIds.add("Q11e7-6c4a-54176aed-966a-876161d2b77c"); //时效报表
//        widgetIds.add("Q11e7-67a1-57faa8f0-bb6a-ff15ffadffa1"); //计算脚本
//        widgetIds.add("Q11e7-67cc-0304449e-bb6a-ff15ffadffa1"); //链接内容_icon
//        widgetIds.add("Q11e7-67cd-728d78c4-bb6a-ff15ffadffa1"); //授权方式-自动化组长可见
//        widgetIds.add("Q11e7-679f-970641fb-bb6a-ff15ffadffa1"); //摘要
//        widgetIds.add("Q11e7-67cb-5ea2d0c3-bb6a-ff15ffadffa1"); //时效报表_icon
//        widgetIds.add("Q11e7-67a0-f2fd635a-bb6a-ff15ffadffa1"); //交叉报表
//        widgetIds.add("Q11e7-67cb-ab88f1ac-bb6a-ff15ffadffa1"); //交叉报表_icon
//        widgetIds.add("Q11e7-6c4a-66734702-966a-876161d2b77c"); //图形报表
//        widgetIds.add("Q11e7-67cb-701bedca-bb6a-ff15ffadffa1"); //图形报表_icon
//        widgetIds.add("Q11e7-67a0-0e34831c-bb6a-ff15ffadffa1"); //快速入口
//        widgetIds.add("Q11e7-679d-3a578553-bb6a-ff15ffadffa1"); //快速入口_icon
//        widgetIds.add("Q11e7-679f-d45c9dfa-bb6a-ff15ffadffa1"); //视图
//        widgetIds.add("Q11e7-67a0-497e4613-bb6a-ff15ffadffa1"); //视图_icon
//        widgetIds.add("Q11e7-6c4b-cade90cc-966a-876161d2b77c"); //计算脚本-高度
//        widgetIds.add("Q11e7-6c6a-c01600e8-af7b-510e9c33aad3"); //通过脚本抄送
//        widgetIds.add("Q11e7-6c6a-b1493f01-af7b-510e9c33aad3"); //通过角色抄送
//        widgetIds.add("Q11e7-67a0-5e66e788-bb6a-ff15ffadffa1"); //链接内容

        for (String widgetId : widgetIds) {
            //访问URL
            String url = "/api/runtime/widgets/{widgetId}"
                    .replace("{widgetId}", widgetId);

            // 构建请求
            MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
            requestBuilder.cookie(cookie);
            ResultActions resultActions = mockMvc.perform(requestBuilder);

            //返回结果
            resultActions.andDo(print());
            resultActions.andExpect(status().isOk());
            resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
            resultActions.andExpect(jsonPath("$.errcode").value(0));
            resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        }
    }

    /**
     * 测试  /api/runtime/{applicationId}/homepage/users/{userId}/config 接口<br/>
     * 获取指定用户首页Widget配置
     * @throws Exception
     */
    @Test
    public void doGetUserPageWidgetSetting() throws Exception {

        session.setAttribute(Web.SESSION_ATTRIBUTE_USERLANGUAGE, "CN");

        //请求参数
        //String userId = "Q11e7-5f9a-210f9112-917f-e799edecb417";

        //访问URL
        String url = "/api/runtime/homepage/config";


        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

    }

    /**
     * 测试  POST /api/runtime/{applicationId}/homepage/users/{userId}/config 接口<br/>
     * 保存指定用户首页Widget配置
     * @throws Exception
     */
    @Test
    public void doSaveUserPageWidgetSetting() throws Exception {

        //请求包体

        JSONArray appL = new JSONArray();
        JSONArray appM = new JSONArray();
        JSONArray appR = new JSONArray();
        JSONArray appIcon = new JSONArray();

        appM.add("Q11e7-6c4a-66734702-966a-876161d2b77c");
        appM.add("Q11e7-6c4a-54176aed-966a-876161d2b77c");
        appM.add("Q11e7-67a1-57faa8f0-bb6a-ff15ffadffa1");
        appM.add("Q11e7-6c6a-b1493f01-af7b-510e9c33aad3");
        appM.add("system_announcement");
        appM.add("system_weather");
        appM.add("system_knowledge");


        appIcon.add("Q11e7-67cb-ab88f1ac-bb6a-ff15ffadffa1");
        appIcon.add("Q11e7-67cb-701bedca-bb6a-ff15ffadffa1");
        appIcon.add("Q11e7-67cb-5ea2d0c3-bb6a-ff15ffadffa1");
        appIcon.add("Q11e7-67cc-0304449e-bb6a-ff15ffadffa1");


        appL.add("Q11e7-67a0-f2fd635a-bb6a-ff15ffadffa1");
        appL.add("Q11e7-679f-970641fb-bb6a-ff15ffadffa1");
        appL.add("Q11e7-6c4b-cade90cc-966a-876161d2b77c");
        appL.add("Q11e7-6c6a-c01600e8-af7b-510e9c33aad3");
        appL.add("Q11e7-67a0-5e66e788-bb6a-ff15ffadffa1");
        appL.add("system_workflow");
        appL.add("system_email");
        appL.add("system_empconbook");

        JSONObject setting = new JSONObject();
        setting.put("layoutStyle", "1:1:1");
        setting.put("appR",appR);
        setting.put("appL",appL);
        setting.put("appM",appM);
        setting.put("appIcon",appIcon);

        System.out.println(setting.toJSONString());

//        //请求参数
//        String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
//        String userId = "Q11e7-5f9a-210f9112-917f-e799edecb417";

        //访问URL
        String url = "/api/runtime/homepage/config";


        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(url);
        requestBuilder.cookie(cookie);
        requestBuilder.content(setting.toJSONString());
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

    }

    @Test
    public void testlistCirculatorByUser() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/widget/myCopy");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testqueryPendingByUser() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/widget/myPending");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testqueryProcessingByUser() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/widget/myProcessing");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

}