package cn.myapps.runtime.userSetup.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * userSetups RESTful test
 * @author spy
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class UserSetupControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        String userid = "zPsp2hk7CEwtqeMCwtj";
        UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
        String token = Security.getToken(userid);
        // 存放到cookie
        cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
//		response.addCookie(cookie);
    }
    
    @Test
    public void setUserPassword() throws Exception {

        //访问URL
        String url = "/api/runtime/usersetups/password";
        JSONObject json = new JSONObject();
        json.put("oldPassword", "654321");
        json.put("newpassword", "654321");
        json.put("confirmPassword", "654321");
        String content = json.toString();
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder.content(content));

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
    
    @Test
    public void setUserDetail() throws Exception {

        //访问URL
        String url = "/api/runtime/usersetups/detail";
        JSONObject json = new JSONObject();
        json.put("name", "大间谍");
        json.put("email", "7122237751@qq.com");
        json.put("telephone", "14323426734");
        String content = json.toString();
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder.content(content));

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
    
    @Test
    public void getUserProxys() throws Exception {
    	String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";

        //访问URL
        String url = "/api/runtime/" + applicationId + "/usersetups/proxys";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
    
    @Test
    public void deleteUserProxy() throws Exception {
    	String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
    	
        //访问URL
        String url = "/api/runtime/" + applicationId + "/usersetups/proxys";
        JSONArray list = new JSONArray();
        list.add("T9mV3xGnc3EFNm4JMpZ");
        list.add("zDIBjdMIk1BuVXETzMZ");
        String content = list.toString();
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildDeleteRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder.content(content));

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
    
    @Test
    public void saveUserProxy() throws Exception {
    	String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
    	String id = "";
        //访问URL
        String url = "/api/runtime/" + applicationId + "/usersetups/proxys/save";
        JSONObject json = new JSONObject();
        json.put("description", "123");
        json.put("proxyMode", 1);
        json.put("startProxyTime","2018-12-12 00:00:00");
        json.put("endProxyTime","2018-12-22 00:00:00");
        String content = json.toString();
        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder.content(content));

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
    
    @Test
    public void getUserProxyFlowName() throws Exception {
    	String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
    	
        //访问URL
        String url = "/api/runtime/" + applicationId + "/usersetups/proxys/flows";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void getDomains() throws Exception {
        //访问URL
        String url = "/api/runtime/usersetups/domains";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void switchDomain() throws Exception {
        String domainId = "3CffNlgt9B9StIjIUPB";
        //访问URL
        String url = "/api/runtime/usersetups/domains/switch?domain="+domainId;

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void getUserProxy() throws Exception {
        String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";

        String id ="UFh1zDAbuUhlLoQa2tA";

        //访问URL
        String url = "/api/runtime/" + applicationId + "/usersetups/proxys/"+id;

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}
