package cn.myapps.runtime.user.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * User Restful 测试类
 * 
 * @author spy
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class UserSelectboxControllerTest extends AbstractControllerTests{

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}
	/**
	 * 测试 GET /api/runtime/{applicationId}/users/selectbox/department?deptId={deptId} 接口<br/>
	 * 获取以部门为树形结构的用户集合<br/>
	 * 返回直属下级部门和用户的集合，以树形结构的方式描述数据。
	 */
	@Test
	public void testGetUserListAsDeptTree() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String deptId = "";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/"+applicationId+"/users/selectbox/department?deptId="+deptId);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/users/selectbox/role?roleId={roleId} 接口<br/>
	 * 获取以角色为树形结构的用户集合<br/>
	 * 返回该角色下的用户的集合，以树形结构的方式描述数据。
	 */
	@Test
	public void testGetUserListAsRoleTree() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String roleId = "0Q0LkJpfR1ejtO8rD3p";
		Integer pageSize = null;
		Integer pageNum = null;
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/"+applicationId+"/users/selectbox/role?roleId="+roleId+"&pageSize="+pageSize+"&pageNum="+pageNum);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/users/selectbox/contacts 接口<br/>
	 * 获取以通讯录为树形结构的用户集合<br/>
	 * 返回通讯录下所有用户的集合，以树形结构的方式描述数据。
	 */
	@Test
	public void testGetUserListAsContactsTree() throws Exception {
		//String applicationId = "Q11e0-64cb-0102bc66-a16d-737e9c8ca3b8";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/users/selectbox/contacts");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/users/selectbox/onlines 接口<br/>
	 * 获取在线用户集合<br/>
	 * 返回通讯录下在线用户集合。
	 */
	@Test
	public void testGetOnlineUserList() throws Exception {
//		String userid = "zPsp2hk7CEwtqeMCwtj";
//		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		WebUser webUser = new WebUser(user);
//		WebUser.setWebUser(webUser, session);
//		// 构建请求
//		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
//				"/api/runtime/users/selectbox/onlines");
//		requestBuilder.cookie(cookie);
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//
//		resultActions.andDo(print());
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
}
