package cn.myapps.runtime.user.controller;

import static com.jayway.jsonpath.JsonPath.parse;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.jayway.jsonpath.DocumentContext;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * Created by Seven on 2017/11/14.
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class UserControllerTest extends AbstractControllerTests {

    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        String userid = "zPsp2hk7CEwtqeMCwtj";
        UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO user = (UserVO) uProcess.doView(userid);
        String token = Security.getToken(user.getId());
        // 存放到cookie
        cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
//		response.addCookie(cookie);
    }

    @Test
    public void getLoginUser() throws Exception {

        //访问URL
        String url = "/api/runtime/users/myprofile";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(url);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        //返回结果
        resultActions.andDo(print());
        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

//    @Test
//    public void testlogout() throws Exception {
//        String url = "/logout";
//
//        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(url);
//        requestBuilder.cookie(cookie);
//        ResultActions resultActions = mockMvc.perform(requestBuilder);
//        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//        resultActions.andExpect(jsonPath("$.errcode").value(0));
//        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//    }

    @Test
    public void testgetSelectUser() throws Exception {
        String id = "zPsp2hk7CEwtqeMCwtj";

        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/users/profile?id="+id);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testgetLoginUserSigns() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/users/signs");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testsaveLoginUserSign() throws Exception {
        String content = "{\n" +
                "\t\"id\": \"zPsp2hk7CEwtqeMCwtj\",\n" +
                "\t\"name\": \"1111\",\n" +
                "\t\"password\": \"123456\",\n" +
                "\t\"img\": \"XdUeahX5pMWYxjzdUVg.jpg\",\n" +
                "\t\"desc\": \"3333\",\n" +
                "\t\"date\": \"2018-09-05\"\n" +
                "}";

        MockHttpServletRequestBuilder requestBuilder = buildPostRequest("/api/runtime/users/signs");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testdeleteLoginUserSigns() throws Exception {
        String content ="[\"zPsp2hk7CEwtqeMCwtj\",\"0TblO2uKjQ2sLDY64yF\",\"0URvyCUds2T4PGx4yLB\"]";
//        String content = "";

        MockHttpServletRequestBuilder requestBuilder = buildDeleteRequest("/api/runtime/users/signs");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testdeleteLoginUserSign() throws Exception {
        String id = "zPsp2hk7CEwtqeMCwtj";

        MockHttpServletRequestBuilder requestBuilder = buildDeleteRequest("/api/runtime/users/signs/"+id);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testsetUserSkin() throws Exception {
        String content = "{\"skin\":\"H5\"}";

        MockHttpServletRequestBuilder requestBuilder = buildPostRequest("/api/runtime/users/skin");
        requestBuilder.content(content);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testvalidatePassword() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildPutRequest("/api/runtime/users/unlock");
        String content = "{\"123456\"}";
        requestBuilder.content(content);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testgetCommonOpinions() throws Exception {
        String userId = "zPsp2hk7CEwtqeMCwtj";

        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/users/"+userId+"/commonOpinions");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testaddCommonOpinion() throws Exception {
        String userId = "zPsp2hk7CEwtqeMCwtj";

        MockHttpServletRequestBuilder requestBuilder = buildPostRequest("/api/runtime/users/"+userId+"/commonOpinions?opinion=1231");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

        String content = resultActions.andReturn().getResponse().getContentAsString();
        DocumentContext parse = parse(content);
        String opid = parse.read("$.data.id");

        requestBuilder = buildDeleteRequest("/api/runtime/users/"+userId+"/commonOpinions/"+opid);
        requestBuilder.cookie(cookie);
        resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void updateCommonOpinion() throws Exception {
        String userId = "zPsp2hk7CEwtqeMCwtj";
        String opid = "6d1d5781-a732-4665-a784-635eda060a96";

        MockHttpServletRequestBuilder requestBuilder = buildPutRequest("/api/runtime/users/"+userId+"/commonOpinions/"+opid+"?opinion=1231");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

//    /**
//     * /sequence
//     * 获取系列号
//     * @throws Exception
//     */
//    @Test
//    public void testgetSequence() throws Exception {
//
//        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/sequence");
//        requestBuilder.cookie(cookie);
//        ResultActions resultActions = mockMvc.perform(requestBuilder);
//        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//        resultActions.andExpect(jsonPath("$.errcode").value(0));
//        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//    }

    @Test
    public void testgetUsersBySearch() throws Exception {
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest("/api/runtime/users/selectbox/search?keyWord=a&pageNum=1&pageSize=10");
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }
}
