package cn.myapps.runtime.message.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONArray;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * message Restful 测试类
 * @author spy
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class MessageControllerTest extends AbstractControllerTests{

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}
	
	/**
	 * 测试 GET /api/runtime/messages/notices 接口
	 * 获取通知
	 * 返回通知数据。
	 */
	@Test
	public void testGetNotices() throws Exception {
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/messages/notices");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
	
	/**
	 * 测试 PUT /api/runtime/messages/notices/{ID}/read 接口
	 * 标记已读
	 */
	@Test
	public void testSet2Read() throws Exception {
		String id = "EuF8csUTFCYcEgd6Pva";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/messages/notices/" + id + "/read");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
	
	/**
	 * 测试 PUT /api/runtime/messages/notices/read 接口
	 * 标记全部已读
	 */
	@Test
	public void testSetAll2Read() throws Exception {
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPutRequest(
				"/api/runtime/messages/notices/read");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
	
	/**
	 * 测试 DELETE /api/runtime/messages/notices/delete 接口
	 * 删除通知
	 */
	@Test
	public void testDelete() throws Exception {
		
		JSONArray json = new JSONArray();
		json.add("Q11e7-6f98-6c519fb0-af7b-510e9c33aad3");
		json.add("Q11e7-6ee8-10ab9dc2-af7b-510e9c33aad3");
		String content = json.toJSONString();
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildDeleteRequest(
				"/api/runtime/messages/notices/delete");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
}
