package cn.myapps.runtime.menu.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class MenuControllerTest extends AbstractControllerTests {

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/menus 接口<br/>
	 * 获取菜单<br/>
	 * 获取登陆用户有权限打开的菜单列表
	 */
	@Test
	public void testMenuOfApplication() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";

		// 构建请求
		RequestBuilder requestBuilder = buildGetRequest("/api/runtime/" + applicationId + "/menus");

		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").isArray());

	}

}
