package cn.myapps.runtime.formhelper.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class FormHelperControllerTest extends AbstractControllerTests {
    Cookie cookie;

    @Before
    public void initUser() throws Exception {
        String userid = "zPsp2hk7CEwtqeMCwtj";
        UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
        String token = Security.getToken(userid);
        // 存放到cookie
        cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
        cookie.setPath("/");
//		response.addCookie(cookie);
    }

    @Test
    public void testdoFilePrintWithWaterMark() throws Exception{
        String applicationId = "sOZu9kthmxyP8qQfq0e";
        String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
        String content = "{\"path\":\"/uploads/item/2019/ef5bcd5e-909a-445-0cad14a7f0be.doc\",\"fileName\":\"abc.doc\",\"itemId\":\"vF6Kep6uOGQg0zEzM6U\"}";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
                "/api/runtime/" + applicationId + "/documents/" + docid + "/files/watermark/print");
        requestBuilder.cookie(cookie);
        requestBuilder.content(content);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    @Test
    public void testgetFieldModifiedLog() throws Exception{
        String application = "sOZu9kthmxyP8qQfq0e";
        String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
        String fieldName = "readonlyScript";

        // 构建请求
        MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                "/api/runtime/" + application + "/documents/" + docid + "/formhelper/inputlog?fieldName="+fieldName);
        requestBuilder.cookie(cookie);
        ResultActions resultActions = mockMvc.perform(requestBuilder);

        resultActions.andExpect(status().isOk());
        resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
        resultActions.andExpect(jsonPath("$.errcode").value(0));
        resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
    }

    /**
     * /api/runtime/files/preview/environment
     * 判断是否配置预览环境(用于在线预览)
     */
    @Test
    public void testpreviewEnabled() {
        try {
            // 构建请求
            MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
                    "/api/runtime/files/preview/environment");
            requestBuilder.cookie(cookie);
            ResultActions resultActions = mockMvc.perform(requestBuilder);

            resultActions.andExpect(status().isOk());
            resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
            resultActions.andExpect(jsonPath("$.errcode").value(0));
            resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
        } catch (Exception e){

        }

    }
}
