package cn.myapps.runtime.flowcenter;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * flowcenter Restful 测试类
 * @author spy
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class FlowCenterControllerTest extends AbstractControllerTests{
	
	/**
	 * 模拟用户登陆，将用户对象放入session中。
	 */
	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/flowcenters/startmenus 接口
	 * 获取发起菜单
	 * 返回发起菜单数据。
	 */
	@Test
	public void testGetStartMenus() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/flowcenters/startmenus");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/flowcenters/navs/pendings 接口
	 * 获取待办导航
	 * 返回待办导航数据。
	 */
	@Test
	public void testGetPendingNavs() throws Exception {
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/flowcenters/navs/pendings?applicationId=sOZu9kthmxyP8qQfq0e");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/flowcenters/navs/processeds 接口
	 * 获取经办导航
	 * 返回经办导航数据。
	 */
	@Test
	public void testGetProcessedNavs() throws Exception {
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/flowcenters/navs/processeds?applicationId=sOZu9kthmxyP8qQfq0e");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/flowcenters/pendings 接口
	 * 获取待办列表
	 * 返回待办列表数据
	 */
	@Test
	public void testGetPendings() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/flowcenters/pendings?title=&initiatorId=&flowId=&pageNo=2");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/flowcenters/processeds 接口
	 * 获取经办列表
	 * 返回经办列表数据
	 */
	@Test
	public void testGetProcesseds() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/flowcenters/processeds?title=&initiatorId=&flowId=");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}

	@Test
	public void testgetApplications() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/applications");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
}
