package cn.myapps.runtime.dynaform.view.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.view.editmode.DesignEditMode;
import cn.myapps.run.RuntimeWithConsulApp;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;

/**
 * View Restful 测试类
 * 
 * @author ahan
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class ViewEditModeTest extends AbstractControllerTests {

	Cookie cookie;
	WebUser webUser;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) uProcess.doView(userid);
		webUser = new WebUser(user);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/views/{id}/documents 接口<br/>
	 * 获取视图数据<br/>
	 */
	@Test
	public void testGetDocuments() throws Exception {

		DesignEditMode mode = new DesignEditMode(null);
		ParamsTable params = new ParamsTable();
		String scope = null;
		List<Object> sqlParamList = new ArrayList();

		//数据审批人仅为当前用户自己时可见
		String msg1 = "数据审批人仅为当前用户自己时可见";
		String condition1 = "[{_authFields:'auditor',_authFieldScope:'itself'}]";
		
		//数据作者的所有上级用户可见
		String msg2 = "数据作者的所有上级用户可见";
		String condition2 = "[{_authFields:'author',_authFieldScope:'allSuperior'}]";
		
		//数据作者默认部门所用下级部门用户可见
		String msg3 = "数据作者默认部门所用下级部门用户可见";
		String condition3 = "[{_authFields:'authorDefaultDept',_authFieldScope:'allLower'}]";
		
		//数据作者默认部门直属下级部门用户可见
		String msg4 = "数据作者默认部门直属下级部门用户可见";
		String condition4 = "[{_authFields:'authorDefaultDept',_authFieldScope:'lineLower'}]";
		
		//数据作者默认部门用户可见
		String msg5 = "数据作者默认部门用户可见";
		String condition5 = "[{_authFields:'authorDefaultDept',_authFieldScope:'default'}]";
		
		//数据作者直属上级用户可见
		String msg6 = "数据作者直属上级用户可见";
		String condition6 = "[{_authFields:'author',_authFieldScope:'superior'}]";
		
		//数据作者所有下级用户可见
		String msg7 = "数据作者所有下级用户可见";
		String condition7 = "[{_authFields:'author',_authFieldScope:'allLower'}]";
		
		//数据作者默认部门的所有上级部门用户可见
		String msg8 = "数据作者默认部门的所有上级部门用户可见";
		String condition8 = "[{_authFields:'authorDefaultDept',_authFieldScope:'allSuperior'}]";
		
		//数据作者仅作者自己可见
		String msg9 = "数据作者仅作者自己可见";
		String condition9 = "[{_authFields:'author',_authFieldScope:'itself'}]";
		
		//数据作者默认部门直属上级部门用户可见
		String msg10 = "数据作者默认部门直属上级部门用户可见";
		String condition10 = "[{_authFields:'authorDefaultDept',_authFieldScope:'lineSuperior'}]";
		
		//按处理过，作用为自己  ----废弃此选项
//		String msg11 = "按处理过，作用为自己  ----废弃此选项";
		//[{_authFields:'processed',_authFieldScope:'itself'}]
		
		//按作者作用为直属下级用户
		String msg11 = "按作者作用为直属下级用户";
		String condition11 = "[{_authFields:'author',_authFieldScope:'lower'}]";
		
		TableMapping tableMapping = new TableMapping(new Form());
		
		String sql1 = mode.parseAuthCondition(params, webUser, condition1, tableMapping,sqlParamList);
		System.out.println(msg1);
		System.out.println(condition1 + " -- " + sql1);
		
		String sql2 = mode.parseAuthCondition(params, webUser, condition2, tableMapping,sqlParamList);
		System.out.println(msg2);
		System.out.println(condition1 + " -- " + sql2);

		String sql3 = mode.parseAuthCondition(params, webUser, condition3, tableMapping,sqlParamList);
		System.out.println(msg3);
		System.out.println(condition1 + " -- " + sql3);

		String sql4 = mode.parseAuthCondition(params, webUser, condition4, tableMapping,sqlParamList);
		System.out.println(msg4);
		System.out.println(condition1 + " -- " + sql4);

		String sql5 = mode.parseAuthCondition(params, webUser, condition5, tableMapping,sqlParamList);
		System.out.println(msg5);
		System.out.println(condition1 + " -- " + sql5);

		String sql6 = mode.parseAuthCondition(params, webUser, condition6, tableMapping,sqlParamList);
		System.out.println(msg6);
		System.out.println(condition1 + " -- " + sql6);

		String sql7 = mode.parseAuthCondition(params, webUser, condition7, tableMapping,sqlParamList);
		System.out.println(msg7);
		System.out.println(condition1 + " -- " + sql7);

		String sql8 = mode.parseAuthCondition(params, webUser, condition8, tableMapping,sqlParamList);
		System.out.println(msg8);
		System.out.println(condition1 + " -- " + sql8);

		String sql9 = mode.parseAuthCondition(params, webUser, condition9, tableMapping,sqlParamList);
		System.out.println(msg9);
		System.out.println(condition1 + " -- " + sql9);

		String sql10 = mode.parseAuthCondition(params, webUser, condition10, tableMapping,sqlParamList);
		System.out.println(msg10);
		System.out.println(condition1 + " -- " + sql10);

		String sql11 = mode.parseAuthCondition(params, webUser, condition11, tableMapping,sqlParamList);
		System.out.println(msg11);
		System.out.println(condition1 + " -- " + sql11);

	}

}
