package cn.myapps.runtime.dynaform.view.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * View Restful 测试类
 * 
 * @author ahan
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class ViewControllerTest extends AbstractControllerTests {

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/views/{id} 接口<br/>
	 * 获取视图<br/>
	 * 服务器返回包含视图模板、操作、列但不包含视图数据的结果。
	 */
	@Test
	public void testGetView() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";

		// 构建请求
		RequestBuilder requestBuilder = buildGetRequest("/api/runtime/" + applicationId + "/views/" + id + "/template");

		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/views/{id}/documents 接口<br/>
	 * 获取视图数据<br/>
	 */
	@Test
	public void testGetDocuments() throws Exception {


		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";
		String content = "{}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/views/" + id + "/documents?parentId=&sortCol=&sortStatus=&_currpage=1&lines=05&treedocid=&parentNodeId=&_docid=&_fieldid=&isRelate=&startDate=&endDate=&_=0.5771032330166874");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	@Test
	public void doGetTreeDocuments() {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id ="__8ggTzyy9drzN7L4TPqr";
		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("parentId", "");
		params.add("name", "");
		String content = "{}";
		try {
			MockHttpServletRequestBuilder request = buildPostRequest("/api/runtime/" + applicationId + "/treeviews/"+id+"/documents");
			request.cookie(cookie);
			request.params(params).content(content);
			mockMvc.perform(request).andExpect(jsonPath("$.errcode").value(0))
					.andExpect(jsonPath("$.errmsg").value("ok"));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void dodoGetTreeDocuments() {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id ="__8ggTzyy9drzN7L4TPqr";
		MultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>();
		params.add("parentId", "");
		params.add("name", "");
		String content = "{}";
		try {
			MockHttpServletRequestBuilder request = buildPostRequest("/api/runtime/" + applicationId + "/treeviews/"+id+"/documents");
			request.cookie(cookie);
			request.params(params).content(content);
			mockMvc.perform(request).andExpect(jsonPath("$.errcode").value(0))
					.andExpect(jsonPath("$.errmsg").value("ok"));
		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void testgetSearchFormTemplate() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/views/" + id + "/searchformtemplate");
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	@Test
	public void testdoGetView() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/views/" + id + "/template");

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	@Test
	public void testviewsOpenable() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/views/" + id + "/openable");

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 视图列的提交按钮
	 * /api/runtime/{applicationId}/views/{viewId}/column/submit
	 * @throws Exception
	 */
	@Test
	public void viewColumnApprove() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";
		String content = "{\n" +
				"    \"docId\":\"__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl\",\n" +
				"    \"approveLimit\":\"abc,abb,bbbc\",\n" +
				"    \"attitude\":\"222\"\n" +
				"}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/views/" + id + "/column/submit");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 刷新表单
	 * /views/{viewid}/documents/{docid}/refresh
	 * @throws Exception
	 */
	@Test
	public void testRowRefresh() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String id = "__8ggTzyy9drzN7L4TPqr";
		String docid = "__AND133Vh0FXzJsQX60f";
		String content = "{}";
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/views/" + id + "/documents/"+docid+"/refresh");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
}
