package cn.myapps.runtime.dynaform.form.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * wordfield RESTful 测试类
 * @author spy
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class WordFieldControllerTest extends AbstractControllerTests {

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/forms/wordfield/edit?wordid={wordid} 接口<br/>
	 * Word控件-判断是否可编辑<br/>
	 * 服务器返回:
	 * 		1.可编辑，返回(null）
	 * 	 	2.不可编辑，返回(当前正在编辑word文档的用户信息对象)
	 */
	@Test
	public void testCheckWordFieldEdit() throws Exception {
		String wordid = "Q11e7-76dd-cefc7139-aa03-c5c684d033ca";

		// 1.进入编辑
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/forms/wordfield/edit?wordid=" + wordid);
		requestBuilder.cookie(cookie);
		this.mockMvc.perform(requestBuilder).andExpect(status().isOk()).andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		// 2.更换登陆用户
		String userid = "0JyBHSIZPmSOQpQwd1K";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) uProcess.doView(userid);
		WebUser webUser = new WebUser(user);
		WebUser.setWebUser(webUser, request);
		// 3.进入同一个word编辑
		requestBuilder = buildGetRequest(
				"/api/runtime/forms/wordfield/edit?wordid=" + wordid);
		requestBuilder.cookie(cookie);
		this.mockMvc.perform(requestBuilder).andExpect(status().isOk()).andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));

	}

	/**
	 * 测试 PUT /api/runtime/forms/wordfield/exixtEdit?wordid={wordid} 接口<br/>
	 * Word控件-退出编辑<br/>
	 */
	@Test
	public void testExixtEdit() throws Exception {
		String wordid = "Q11e7-76dd-cefc7139-aa03-c5c684d033ca";

		// 1.进入word编辑
		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/forms/wordfield/edit?wordid=" + wordid);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

		// 2.退出word编辑
		requestBuilder = buildPutRequest(
				"/api/runtime/forms/wordfield/exixtEdit?wordid=" + wordid);
		requestBuilder.cookie(cookie);
		resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

		// 3.再次进入同一个word编辑
		requestBuilder = buildGetRequest(
				"/api/runtime/forms/wordfield/edit?wordid=" + wordid);
		requestBuilder.cookie(cookie);
		resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}
}
