package cn.myapps.runtime.dynaform.form.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class SuggestFieldControllerTest extends AbstractControllerTests {
	
	/**
	 * 模拟用户登陆，将用户对象放入session中。
	 * 
	 * @throws Exception
	 */
	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}
	
	/**
	 * 测试 GET /api/runtime/{applicationId}/forms/{formid}/documents/{docid}/querySuggest 接口<br/>
	 * 智能搜索提示框-查询<br/>
	 * 服务器返回搜索提示相关的信息
	 */
	@Test
	public void testQuerySuggest() throws Exception {

		String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
		String formid = "Qf4NDOEOVMi7vrgWjzz4";
		String docid = "tx20GXWipPavQ8sqvJy";

		String content = "{\"parentId\":\"\",\"formFieldId\":\"Q8LzY6lrpAdaPtQnD1zD\",\"keyword\":\"cc\"}";

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/" + docid + "/querySuggest");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);

		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}
}
