package cn.myapps.runtime.dynaform.form.controller;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import javax.servlet.http.Cookie;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

/**
 * Form Restful 测试类
 * 
 * @author ahan
 *
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class FormControllerTest extends AbstractControllerTests {

	String userid = "zPsp2hk7CEwtqeMCwtj";

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/forms/{formid}/documents/{docid} 接口<br/>
	 * 获取表单模板<br/>
	 * 服务器返回包含表单模板、操作、样式库、权限（数据与权限体现在表单控件的属性）的结果。
	 */
	@Test
	public void testFindFormDataPacket() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formid = "__r3Uat20oAOwkP9f8fCl";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		RequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/" + docid);
		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/forms/{formid}/documents/{docid}/openable 接口<br/>
	 * 判断表单打开权限<br/>
	 * 执行表单是否可打开脚本，返回运算结果（true/false）。
	 */
	@Test
	public void testDocumentOpenable() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formid = "__r3Uat20oAOwkP9f8fCl";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		RequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/" + docid + "/openable");
		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

		formid = "__r3Uat20oAOwkP9f8fCl";
		docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/" + docid + "/openable");
		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
		resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
		resultActions.andExpect(jsonPath("$.data").value(true));

	}

	/**
	 * 测试 GET /api/runtime/{applicationId}/forms/{formid}/documents/{docid}/refresh 接口<br/>
	 * 刷新表单<br/>
	 * 表单某控件触发全局刷新表单的动作，服务器根据最新的文档状态重新运算开启重计算功能的全部控件的值脚本，返回状态发生变更的控件内容。
	 */
	@Test
	public void testDocumentRefresh() throws Exception {

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formid = "__r3Uat20oAOwkP9f8fCl";
		String docid = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		JSONObject json = new JSONObject();
		json.put("actField", docid + "_刷新表单");
		json.put("tabId", "");
		JSONObject docement = new JSONObject();
		JSONObject items = new JSONObject();
		items.put("文本一", "触发刷新");
		items.put("文本二", "");
		docement.put("items", items);
		docement.put("formId",formid);
		docement.put("id",docid);
		json.put("document", docement);

		String content = json.toJSONString();

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/" + docid + "/refresh");

		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 测试 POST /api/runtime/{applicationId}/forms/{formid}/empty 接口<br/>
	 * 新建空文档<br/>
	 * 服务器创建一个空的文档缓存并返回一个临时的文档。
	 */
	@Test
	public void testNewDocument() throws Exception{

		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formId = "__r3Uat20oAOwkP9f8fCl";

		try {
			MockHttpServletRequestBuilder request = buildGetRequest(
					"/api/runtime/" + applicationId + "/forms/" + formId + "/empty");
			request.cookie(cookie);
			ResultActions resultActions = mockMvc.perform(request);

			resultActions.andExpect(status().isOk());
			resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
			resultActions.andExpect(jsonPath("$.errcode").value(0));
			resultActions.andExpect(jsonPath("$.data.istmp").value(true));
			resultActions.andExpect(jsonPath("$.data.formid").value(formId));

			// 带有流程处理的表单应该有瞬态的流程实例
			formId = "__r3Uat20oAOwkP9f8fCl";
			request = buildGetRequest(
					"/api/runtime/" + applicationId + "/forms/" + formId + "/empty");
			request.cookie(cookie);
			resultActions = mockMvc.perform(request);
			resultActions.andExpect(status().isOk());
			resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
			resultActions.andExpect(jsonPath("$.errcode").value(0));
			resultActions.andExpect(jsonPath("$.data.istmp").value(true));
			resultActions.andExpect(jsonPath("$.data.formid").value(formId));
			resultActions.andExpect(jsonPath("$.data.authorId").value(userid));
			resultActions.andExpect(jsonPath("$.data.versions").value(0));

		} catch (Exception e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void testdocumentOpenable() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formid = "__r3Uat20oAOwkP9f8fCl";

		// 构建请求
		RequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/" + applicationId + "/forms/" + formid + "/openable");

		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

//	@Test
//	public void testfindFormData() throws Exception {
//		String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
//		String formid = "f4NDOEOVMi7vrgWjzz4";
//		String docid = "1BYPOS10KR6a3SZI5FL";
//
//		// 构建请求
//		RequestBuilder requestBuilder = buildGetRequest(
//				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/"+docid+"/data");
//
//		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//
//	}

//	@Test
//	public void testfindFormModel() throws Exception {
//		String applicationId = "Q11e7-5f98-d7d66840-917f-e799edecb417";
//		String formid = "f4NDOEOVMi7vrgWjzz4";
//		String docid = "1BYPOS10KR6a3SZI5FL";
//
//		// 构建请求
//		RequestBuilder requestBuilder = buildGetRequest(
//				"/api/runtime/" + applicationId + "/forms/" + formid + "/documents/"+docid+"/template");
//
//		((MockHttpServletRequestBuilder) requestBuilder).cookie(cookie);
//		ResultActions resultActions = mockMvc.perform(requestBuilder);
//		resultActions.andExpect(status().isOk());
//		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
//		resultActions.andExpect(jsonPath("$.errcode").value(0));
//		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
//
//	}
}
