package cn.myapps.runtime.dynaform.form.controller;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.fileUpload;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.io.FileInputStream;

import javax.servlet.http.Cookie;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.AbstractControllerTests;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.run.RuntimeWithConsulApp;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= RuntimeWithConsulApp.class)
public class FileUploadControllerTest extends AbstractControllerTests {

	Cookie cookie;

	@Before
	public void initUser() throws Exception {
		String userid = "zPsp2hk7CEwtqeMCwtj";
		UserProcess uProcess = AuthTimeServiceManager.userRuntimeService();
//		UserVO user = (UserVO) uProcess.doView(userid);
//		webUser = new WebUser(user);
		String token = Security.getToken(userid);
		// 存放到cookie
		cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
		cookie.setPath("/");
//		response.addCookie(cookie);
	}

	/**
	 * 文件上传测试
	 */
	@Test
	public void testUpload() throws Exception {
		String applicationid = "sOZu9kthmxyP8qQfq0e";
		String allowedTypes = "";
		String fieldid = "";
		String fileSaveMode = "00";
		String path = "ITEM_PATH";
		String actionType = "excelImport";
		String a= PropertyUtil.getPath()+"/uploads/resource/default.doc";
		// 构建请求
		this.mockMvc
				.perform(fileUpload("/api/runtime/upload?applicationId=" + applicationid + "&allowedTypes=" + allowedTypes
						+ "&fieldId=" + fieldid + "&fileSaveMode=" + fileSaveMode + "&path=" + path + "&actionType="
						+ actionType)
						.file(new MockMultipartFile("files", "default.doc", "application/text",
								new FileInputStream(a))).cookie(cookie))
				.andExpect(status().isOk());
	}

	/**
	 * 文件排序
	 */
	@Test
	public void testFileSort() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formId = "__r3Uat20oAOwkP9f8fCl";
		String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";

		JSONObject json = new JSONObject();
		json.put("applicationId", applicationId);
		json.put("formId", formId);
		json.put("docId", docId);
		json.put("itemName", "文件上传");
		json.put("itemValue", "[{\"name\":\"任务 copy.png\",\"path\":\"/uploads/item/2017/66d379b9-88d5-4804-81ce-f766ba82e289.png\"},{\"name\":\"oa copy.png\",\"path\":\"/uploads/item/2017/41a6f08f-e832-4c9c-96ef-1f195b703bcd.png\"}]");
		String content = json.toJSONString();

		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildPostRequest(
				"/api/runtime/files/sort");
		requestBuilder.cookie(cookie);
		requestBuilder.content(content);

		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andDo(print());
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	/**
	 * 文件删除
	 */
	@Test
	public void testFileDelete() throws Exception {
		String applicationId = "sOZu9kthmxyP8qQfq0e";
		String formId = "__r3Uat20oAOwkP9f8fCl";
		String docId = "__iv4VDXP9JA5iY7FXbue--__r3Uat20oAOwkP9f8fCl";
		String fullName = "/uploads/item/2019/2e95c9d2-4507-4bb4-8268-1b689121debe.xlsx";


		// 构建请求
		MockHttpServletRequestBuilder requestBuilder = buildDeleteRequest(
				"/api/runtime/files/delete?applicationId="+applicationId+"&formId="+formId+
						"&docId="+docId+"&fileFullName="+fullName);

		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andDo(print());
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errcode").value(0));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));

	}

	@Test
	public void testgetPdfFile() throws Exception{
		String fileId = "596dc7a0-a065-4765-bc18-38174bac6c68";
		String path = "/uploads/doc/201805/596dc7a0-a065-4765-bc18-38174bac6c68.pdf";

		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/file/"+fileId+"/pdf?path="+path);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andDo(print());
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
	}

	@Test
	public void testhasPdf() throws Exception{
		String filename = "596dc7a0-a065-4765-bc18-38174bac6c68";
		String path = "/uploads/resource/default.pdf";

		MockHttpServletRequestBuilder requestBuilder = buildGetRequest(
				"/api/runtime/files/hasPdf?path="+path+"&fileRealName="+filename);
		requestBuilder.cookie(cookie);
		ResultActions resultActions = mockMvc.perform(requestBuilder);
		resultActions.andDo(print());
		resultActions.andExpect(status().isOk());
		resultActions.andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8_VALUE));
		resultActions.andExpect(jsonPath("$.errmsg").value("ok"));
	}


}
